/**
 * @file
 */

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.help_description = {
    attach: function (context, settings) {
      const parentElements = document.querySelectorAll(".editing-helper-block"); // Select all help sections
      parentElements.forEach((parentElement) => {
        const helpContent = parentElement.querySelector(".help-content"); // Get the specific help content for each section
        let closeBtn = parentElement.querySelector(".helper-close-btn");
        if (helpContent) {
          // Check if the event listener is already attached
          if (!parentElement.getAttribute("data-listener-attached")) {
            // Using event delegation on the parent
            parentElement.addEventListener("click", function (event) {
              const clickedElement = event.target;

              // Check if the clicked element is the toggle button
              if (clickedElement.classList.contains("toggle-help")) {
                // Prevent any parent events from being triggered
                helpContent.classList.toggle("active");
              }
            });
            // Mark the element as having the event listener attached
            parentElement.setAttribute("data-listener-attached", "true");
          }
          closeBtn.addEventListener("click", function (event) {
            helpContent.classList.remove("active");
          });
        }
      });
    },
  };
})(jQuery, Drupal, drupalSettings);
