<?php

namespace Drupal\editing_helper\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class SeedsSettings.
 */
class HelpDescriptionConfigForm extends ConfigFormBase {

  /**
   * Returns a new instance of this class.
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('config.typed'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'editing_helper.help_config',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'editing_helper_help_config';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config("editing_helper.help_config");

    $form['help_config'] = [
      '#type' => 'fieldset',
      '#title' => t('Help Config'),
      '#tree' => FALSE,
    ];

    $form['help_config']['block_title'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Block Title'),
      '#default_value' => $config->get('block_title'),
    ];

    $form['help_config']['block_inline_text'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Block Inline Text'),
      '#default_value' => $config->get('block_inline_text'),
    ];
    $form['help_config']['block_reusable_text'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Block Reusable Text'),
      '#default_value' => $config->get('block_reusable_text'),
    ];
    $form['help_config']['view_field_text'] = [
      '#type' => 'textarea',
      '#title' => $this->t('View Field Text'),
      '#default_value' => $config->get('view_field_text'),
    ];
    $form['help_config']['view_node_text'] = [
      '#type' => 'textarea',
      '#title' => $this->t('View Node Text'),
      '#default_value' => $config->get('view_node_text'),
    ];
    $form['help_config']['view_taxonomy_text'] = [
      '#type' => 'textarea',
      '#title' => $this->t('View Taxonomy Term Text'),
      '#default_value' => $config->get('view_taxonomy_text'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('editing_helper.help_config')
      ->set('block_title', $form_state->getValue('block_title'))
      ->set('block_inline_text', $form_state->getValue('block_inline_text'))
      ->set('block_reusable_text', $form_state->getValue('block_reusable_text'))
      ->set('view_field_text', $form_state->getValue('view_field_text'))
      ->set('view_node_text', $form_state->getValue('view_node_text'))
      ->set('view_taxonomy_text', $form_state->getValue('view_taxonomy_text'))
      ->save();
    $this->messenger()->addStatus($this->t("Seeds Layout configuration has been saved successfully"));
  }

}
