<?php

namespace Drupal\editing_helper\Plugin\views\display_extender;

use Drupal\views\Plugin\views\display_extender\DisplayExtenderPluginBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Views description_helper display extender plugin.
 *
 * @ingroup views_display_extender_plugins
 *
 * @ViewsDisplayExtender(
 *   id = "editing_helper_display_extender",
 *   title = @Translation("views description helper display extender"),
 *   help = @Translation("Settings to add views description in document this view."),
 *   no_ui = FALSE
 * )
 */
class EditingHelperDisplayExtender extends DisplayExtenderPluginBase {

  /**
   * Provide the key options for this plugin.
   */
  public function defineOptionsAlter(&$options) {
    $options['view_description_helper'] = [
      'contains' => [
        'title' => ['default' => ''],
        'description' => ['default' => ''],
      ],
    ];
  }

  /**
   * Provide the default summary for options and category in the views UI.
   */
  public function optionsSummary(&$categories, &$options) {
    $categories['view_description_helper'] = [
      'title' => t('Block Description Helper'),
      'column' => 'second',
    ];
    $view_description_helper = $this->hasMetadata() ? $this->getMetadataValues() : FALSE;
    $options['view_description_helper'] = [
      'category' => 'view_description_helper',
      'title' => t('Block description helper'),
      'value' => $view_description_helper ? $view_description_helper['title'] : $this->t('none'),
    ];
  }

  /**
   * Provide a form to edit options for this plugin.
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {

    if ($form_state->get('section') == 'view_description_helper') {
      $form['#title'] .= t('The description helper for this display');
      $view_description_helper = $this->getMetadataValues();

      $form['view_description_helper']['#type'] = 'container';
      $form['view_description_helper']['#tree'] = TRUE;
      $form['view_description_helper']['title'] = [
        '#title' => $this->t('Description helper title'),
        '#type' => 'textfield',
        '#description' => $this->t('Provide a description helper title of this block'),
        '#default_value' => $view_description_helper['title'],
      ];

      $form['view_description_helper']['description'] = [
        '#title' => $this->t('Description'),
        '#type' => 'textarea',
        '#description' => $this->t('Provide a description helper of this block'),
        '#default_value' => $view_description_helper['description'],
      ];
    }
  }

  /**
   * Validate the options form.
   */
  public function validateOptionsForm(&$form, FormStateInterface $form_state) {}

  /**
   * Handle any special handling on the validate form.
   */
  public function submitOptionsForm(&$form, FormStateInterface $form_state) {
    if ($form_state->get('section') == 'view_description_helper') {
      $view_description_helper = $form_state->getValue('view_description_helper');
      $this->options['view_description_helper'] = $view_description_helper;
    }
  }

  /**
   * Identify whether or not the current display has custom metadata defined.
   */
  public function hasMetadata() {
    $view_description_helper = $this->getMetadataValues();
    return !empty($view_description_helper['title']);
  }

  /**
   * Get the view_description_helper configuration for this display.
   *
   * @return array
   *   The view_description_helper values.
   */
  public function getMetadataValues() {
    $view_description_helper = $this->options['view_description_helper'];

    return $view_description_helper;
  }

}
