!function(e,n){"object"==typeof exports&&"object"==typeof module?module.exports=n():"function"==typeof define&&define.amd?define([],n):"object"==typeof exports?exports.CKEditor5=n():(e.CKEditor5=e.CKEditor5||{},e.CKEditor5.editorAdvancedLink=n())}(self,()=>(()=>{var __webpack_modules__={"./js/ckeditor5_plugins/editorAdvancedLink/src/editoradvancedlinkediting.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ EditorAdvancedLinkEditing)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_typing__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/typing */ \"ckeditor5/src/typing.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ \"./js/ckeditor5_plugins/editorAdvancedLink/src/utils.js\");\n// eslint-disable-next-line import/no-extraneous-dependencies\n\n// eslint-disable-next-line import/no-extraneous-dependencies\n\n\n\nclass EditorAdvancedLinkEditing extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  /**\n   * @inheritdoc\n   */\n  static get pluginName() {\n    return 'EditorAdvancedLinkEditing';\n  }\n\n  init() {\n    const editorAdvancedLinkConfig =\n      this.editor.config.get('editorAdvancedLink');\n\n    if (!editorAdvancedLinkConfig.options) {\n      this.enabledModelNames = [];\n      return;\n    }\n    const enabledViewAttributes = Object.values(\n      editorAdvancedLinkConfig.options,\n    );\n\n    this.enabledModelNames = Object.keys(_utils__WEBPACK_IMPORTED_MODULE_2__.additionalFormElements).filter(\n      (modelName) => {\n        return enabledViewAttributes.includes(\n          _utils__WEBPACK_IMPORTED_MODULE_2__.additionalFormElements[modelName].viewAttribute,\n        );\n      },\n    );\n    this.enabledModelNames.forEach((modelName) => {\n      this._allowAndConvertExtraAttribute(\n        modelName,\n        _utils__WEBPACK_IMPORTED_MODULE_2__.additionalFormElements[modelName].viewAttribute,\n      );\n      this._removeExtraAttributeOnUnlinkCommandExecute(modelName);\n      this._refreshExtraAttributeValue(modelName);\n    });\n\n    this._addExtraAttributeOnLinkCommandExecute(\n      Object.keys(_utils__WEBPACK_IMPORTED_MODULE_2__.additionalFormElements),\n    );\n  }\n\n  _allowAndConvertExtraAttribute(modelName, viewName) {\n    const { editor } = this;\n\n    editor.model.schema.extend('$text', { allowAttributes: modelName });\n\n    // Model -> View (DOM)\n    editor.conversion.for('downcast').attributeToElement({\n      model: modelName,\n      view: (value, { writer }) => {\n        const linkViewElement = writer.createAttributeElement(\n          'a',\n          {\n            [viewName]: value,\n          },\n          { priority: 5 },\n        );\n\n        // Without it the isLinkElement() will not recognize the link and the UI will not show up\n        // when the user clicks a link.\n        writer.setCustomProperty('link', true, linkViewElement);\n\n        return linkViewElement;\n      },\n    });\n\n    // View (DOM/DATA) -> Model\n    editor.conversion.for('upcast').elementToAttribute({\n      view: {\n        name: 'a',\n        attributes: {\n          [viewName]: true,\n        },\n      },\n      model: {\n        key: modelName,\n        value: (viewElement) => viewElement.getAttribute(viewName),\n      },\n    });\n  }\n\n  _addExtraAttributeOnLinkCommandExecute(modelNames) {\n    const { editor } = this;\n    const linkCommand = editor.commands.get('link');\n    let linkCommandExecuting = false;\n\n    linkCommand.on(\n      'execute',\n      (evt, args) => {\n        // Custom handling is only required if an extra attribute was passed into\n        // editor.execute( 'link', ... ).\n        if (\n          !evt.editorAdvancedAttributes ||\n          Object.entries(evt.editorAdvancedAttributes).length === 0\n        ) {\n          return;\n        }\n        if (linkCommandExecuting) {\n          linkCommandExecuting = false;\n          return;\n        }\n\n        // If the additional attribute was passed, we stop the default execution\n        // of the LinkCommand. We're going to create Model#change() block for undo\n        // and execute the LinkCommand together with setting the extra attribute.\n        evt.stop();\n        // Prevent infinite recursion by keeping records of when link command is\n        // being executed by this function.\n        linkCommandExecuting = true;\n        const extraAttributeValues = evt.editorAdvancedAttributes;\n        const { model } = this.editor;\n        const { selection } = model.document;\n\n        // Wrapping the original command execution in a model.change() block to make sure there's a single undo step\n        // when the extra attribute is added.\n        model.change((writer) => {\n          editor.execute('link', ...args);\n\n          const firstPosition = selection.getFirstPosition();\n\n          modelNames.forEach((modelName) => {\n            if (selection.isCollapsed) {\n              const node = firstPosition.textNode || firstPosition.nodeBefore;\n\n              if (extraAttributeValues[modelName]) {\n                writer.setAttribute(\n                  modelName,\n                  extraAttributeValues[modelName],\n                  writer.createRangeOn(node),\n                );\n              } else {\n                writer.removeAttribute(modelName, writer.createRangeOn(node));\n              }\n\n              writer.removeSelectionAttribute(modelName);\n            } else {\n              const ranges = model.schema.getValidRanges(\n                selection.getRanges(),\n                modelName,\n              );\n\n              ranges.forEach((range) => {\n                if (extraAttributeValues[modelName]) {\n                  writer.setAttribute(\n                    modelName,\n                    extraAttributeValues[modelName],\n                    range,\n                  );\n                } else {\n                  writer.removeAttribute(modelName, range);\n                }\n              });\n            }\n          });\n        });\n      },\n      { priority: 'high' },\n    );\n  }\n\n  _removeExtraAttributeOnUnlinkCommandExecute(modelName) {\n    const { editor } = this;\n    const unlinkCommand = editor.commands.get('unlink');\n    const { model } = this.editor;\n    const { selection } = model.document;\n\n    let isUnlinkingInProgress = false;\n\n    // Make sure all changes are in a single undo step so cancel the original unlink first in the high priority.\n    unlinkCommand.on(\n      'execute',\n      (evt) => {\n        if (isUnlinkingInProgress) {\n          return;\n        }\n\n        evt.stop();\n\n        // This single block wraps all changes that should be in a single undo step.\n        model.change(() => {\n          // Now, in this single \"undo block\" let the unlink command flow naturally.\n          isUnlinkingInProgress = true;\n\n          // Do the unlinking within a single undo step.\n          editor.execute('unlink');\n\n          // Let's make sure the next unlinking will also be handled.\n          isUnlinkingInProgress = false;\n\n          // The actual integration that removes the extra attribute.\n          model.change((writer) => {\n            // Get ranges to unlink.\n            let ranges;\n\n            if (selection.isCollapsed) {\n              ranges = [\n                (0,ckeditor5_src_typing__WEBPACK_IMPORTED_MODULE_1__.findAttributeRange)(\n                  selection.getFirstPosition(),\n                  modelName,\n                  selection.getAttribute(modelName),\n                  model,\n                ),\n              ];\n            } else {\n              ranges = model.schema.getValidRanges(\n                selection.getRanges(),\n                modelName,\n              );\n            }\n\n            // Remove the extra attribute from specified ranges.\n            // eslint-disable-next-line max-nested-callbacks\n            ranges.forEach((range) => {\n              writer.removeAttribute(modelName, range);\n            });\n          });\n        });\n      },\n      { priority: 'high' },\n    );\n  }\n\n  _refreshExtraAttributeValue(modelName) {\n    const { editor } = this;\n    const linkCommand = editor.commands.get('link');\n    const { model } = this.editor;\n    const { selection } = model.document;\n\n    linkCommand.set(modelName, null);\n\n    model.document.on('change', () => {\n      linkCommand[modelName] = selection.getAttribute(modelName);\n    });\n  }\n}\n\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/./js/ckeditor5_plugins/editorAdvancedLink/src/editoradvancedlinkediting.js?\n}")},"./js/ckeditor5_plugins/editorAdvancedLink/src/editoradvancedlinkui.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ EditorAdvancedLinkUi)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/ui */ \"ckeditor5/src/ui.js\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ \"./js/ckeditor5_plugins/editorAdvancedLink/src/utils.js\");\n// eslint-disable-next-line import/no-extraneous-dependencies\n\n// eslint-disable-next-line import/no-extraneous-dependencies\n\n\n\nclass EditorAdvancedLinkUi extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  init() {\n    this.groups = {};\n\n    // TRICKY: Work-around until the CKEditor team offers a better solution:\n    // force the ContextualBalloon to get instantiated early thanks to\n    // DrupalImage not yet being optimized like\n    // https://github.com/ckeditor/ckeditor5/commit/c276c45a934e4ad7c2a8ccd0bd9a01f6442d4cd3#diff-1753317a1a0b947ca8b66581b533616a5309f6d4236a527b9d21ba03e13a78d8.\n    if (this.editor.plugins.get('LinkUI')._createViews) {\n      this.editor.plugins.get('LinkUI')._createViews();\n    }\n    this._addExtraFormFields();\n  }\n\n  _addExtraFormFields() {\n    const { editor } = this;\n    // Copy the same solution from LinkUI as pointed out on\n    // https://www.drupal.org/project/drupal/issues/3317769#comment-14985648 and\n    // https://git.drupalcode.org/project/drupal/-/merge_requests/2909/diffs?commit_id=cc2cece3be1a9513b02a53d8a6862a6841ef4d5a.\n    editor.plugins\n      .get('ContextualBalloon')\n      .on('set:visibleView', (evt, propertyName, newValue, oldValue) => {\n        const linkFormView = editor.plugins.get('LinkUI').formView;\n        if (newValue === oldValue || newValue !== linkFormView) {\n          return;\n        }\n\n        const { enabledModelNames } = editor.plugins.get(\n          'EditorAdvancedLinkEditing',\n        );\n        enabledModelNames.reverse().forEach((modelName) => {\n          this._createExtraFormField(\n            modelName,\n            _utils__WEBPACK_IMPORTED_MODULE_2__.additionalFormElements[modelName],\n          );\n        });\n        this._handleExtraFormFieldSubmit(enabledModelNames);\n        // Add groups to form view last to ensure they're not between fields.\n        this._addGroupsToFormView();\n      });\n  }\n\n  _createExtraFormField(modelName, options) {\n    const { editor } = this;\n    const { locale } = editor;\n    const linkFormView = editor.plugins.get('LinkUI').formView;\n    const linkCommand = editor.commands.get('link');\n    if (typeof linkFormView[modelName] === 'undefined') {\n      const fieldParent = options.group\n        ? this._getGroup(options.group)\n        : linkFormView;\n\n      const extraFieldView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.LabeledFieldView(\n        locale,\n        ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.createLabeledInputText,\n      );\n      extraFieldView.label = options.label;\n      // @todo Refactor to use FormRowView instead of setting\n      //       backwards-compatible class selector.\n      extraFieldView.class = 'ck-labeled-field-view--editor-advanced-link';\n      // @todo Fix the display text field from jumping above or below the\n      //       collapsible advanced section when linkTitle is not enabled or\n      //       enabled respectively.\n      fieldParent.children.add(\n        extraFieldView,\n        fieldParent === linkFormView ? 1 : 0,\n      );\n\n      // @todo Fix focus order of form fields in https://www.drupal.org/project/editor_advanced_link/issues/3519379.\n      if (!options.group) {\n        linkFormView._focusables.add(extraFieldView, 1);\n        linkFormView.focusTracker.add(extraFieldView.element);\n      }\n\n      linkFormView[modelName] = extraFieldView;\n      linkFormView[modelName].fieldView\n        .bind('value')\n        .to(linkCommand, modelName);\n      // Note: Copy & pasted from LinkUI.\n      // https://github.com/ckeditor/ckeditor5/blob/f0a093339631b774b2d3422e2a579e27be79bbeb/packages/ckeditor5-link/src/linkui.js#L333-L333\n      linkFormView[modelName].fieldView.element.value =\n        linkCommand[modelName] || '';\n    }\n  }\n\n  _addGroupsToFormView() {\n    if (Object.entries(this.groups).length === 0) {\n      return;\n    }\n\n    const { editor } = this;\n    const linkFormView = editor.plugins.get('LinkUI').formView;\n\n    Object.values(this.groups)\n      .reverse()\n      .forEach((group) => {\n        if (!group.added) {\n          linkFormView.children.add(group, 2);\n          group.parent = linkFormView;\n\n          linkFormView._focusables.add(group, 2);\n          linkFormView.focusTracker.add(group.element);\n\n          group.added = true;\n        }\n      });\n  }\n\n  _getGroup(groupName) {\n    if (!this.groups[groupName]) {\n      const { editor } = this;\n      const { locale } = editor;\n\n      const group = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.CollapsibleView(locale);\n      group.label = _utils__WEBPACK_IMPORTED_MODULE_2__.additionalFormGroups[groupName].label;\n      group.set('isCollapsed', true);\n      this.groups[groupName] = group;\n    }\n    return this.groups[groupName];\n  }\n\n  _handleExtraFormFieldSubmit(modelNames) {\n    const { editor } = this;\n    const linkFormView = editor.plugins.get('LinkUI').formView;\n    const linkCommand = editor.commands.get('link');\n\n    this.listenTo(\n      linkFormView,\n      'submit',\n      () => {\n        const values = modelNames.reduce((state, modelName) => {\n          state[modelName] = linkFormView[modelName].fieldView.element.value;\n          return state;\n        }, {});\n        // Stop the execution of the link command caused by closing the form.\n        // Inject the extra attribute value. The highest priority listener here\n        // injects the argument (here below 👇).\n        // - The high priority listener in\n        //   _addExtraAttributeOnLinkCommandExecute() gets that argument and sets\n        //   the extra attribute.\n        // - The normal (default) priority listener in ckeditor5-link sets\n        //   (creates) the actual link.\n        linkCommand.on(\n          'execute',\n          (evt, args) => {\n            evt.editorAdvancedAttributes = values;\n          },\n          { priority: 'highest' },\n        );\n      },\n      { priority: 'high' },\n    );\n  }\n}\n\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/./js/ckeditor5_plugins/editorAdvancedLink/src/editoradvancedlinkui.js?\n}")},"./js/ckeditor5_plugins/editorAdvancedLink/src/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ "ckeditor5/src/core.js");\n/* harmony import */ var _editoradvancedlinkediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./editoradvancedlinkediting */ "./js/ckeditor5_plugins/editorAdvancedLink/src/editoradvancedlinkediting.js");\n/* harmony import */ var _editoradvancedlinkui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./editoradvancedlinkui */ "./js/ckeditor5_plugins/editorAdvancedLink/src/editoradvancedlinkui.js");\n// eslint-disable-next-line import/no-extraneous-dependencies\n\n\n\n\nclass EditorAdvancedLink extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  /**\n   * @inheritdoc\n   */\n  static get requires() {\n    return [_editoradvancedlinkediting__WEBPACK_IMPORTED_MODULE_1__["default"], _editoradvancedlinkui__WEBPACK_IMPORTED_MODULE_2__["default"]];\n  }\n\n  /**\n   * @inheritdoc\n   */\n  static get pluginName() {\n    return \'EditorAdvancedLink\';\n  }\n}\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  EditorAdvancedLink,\n});\n\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/./js/ckeditor5_plugins/editorAdvancedLink/src/index.js?\n}')},"./js/ckeditor5_plugins/editorAdvancedLink/src/utils.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("{__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   additionalFormElements: () => (/* binding */ additionalFormElements),\n/* harmony export */   additionalFormGroups: () => (/* binding */ additionalFormGroups)\n/* harmony export */ });\nconst additionalFormElements = {\n  linkTitle: {\n    label: Drupal.t('Title'),\n    viewAttribute: 'title',\n  },\n  linkAriaLabel: {\n    label: Drupal.t('ARIA label'),\n    viewAttribute: 'aria-label',\n    group: 'advanced',\n  },\n  linkClass: {\n    label: Drupal.t('CSS classes'),\n    viewAttribute: 'class',\n    group: 'advanced',\n  },\n  linkId: {\n    label: Drupal.t('ID'),\n    viewAttribute: 'id',\n    group: 'advanced',\n  },\n  linkRel: {\n    label: Drupal.t('Link relationship'),\n    viewAttribute: 'rel',\n    group: 'advanced',\n  },\n};\n\nconst additionalFormGroups = {\n  advanced: {\n    label: Drupal.t('Advanced'),\n  },\n};\n\n\n\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/./js/ckeditor5_plugins/editorAdvancedLink/src/utils.js?\n}")},"ckeditor5/src/core.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('{module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/core.js");\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/delegated_./core.js_from_dll-reference_CKEditor5.dll?\n}')},"ckeditor5/src/typing.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('{module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/typing.js");\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/delegated_./typing.js_from_dll-reference_CKEditor5.dll?\n}')},"ckeditor5/src/ui.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('{module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/ui.js");\n\n//# sourceURL=webpack://CKEditor5.editorAdvancedLink/delegated_./ui.js_from_dll-reference_CKEditor5.dll?\n}')},"dll-reference CKEditor5.dll":e=>{"use strict";e.exports=CKEditor5.dll}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e](t,t.exports,__webpack_require__),t.exports}__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./js/ckeditor5_plugins/editorAdvancedLink/src/index.js");return __webpack_exports__=__webpack_exports__.default,__webpack_exports__})());