/**
 * @file
 * CKEditor 5 Table Advanced plugin.
 *
 * @module tableAdvanced/TableAdvanced
 */

import { Plugin } from "ckeditor5/src/core";
import TableAdvancedEditing from "./tableadvancedediting";
import TableAdvancedUI from "./tableadvancedui";

/**
 * The Table Advanced plugin.
 *
 * This plugin adds ID, language direction, and CSS class attributes to tables.
 * It recreates CKEditor 4's "Advanced" tab functionality.
 */
class TableAdvanced extends Plugin {
  /**
   * @inheritdoc
   */
  static get requires() {
    return [TableAdvancedEditing, TableAdvancedUI];
  }

  /**
   * @inheritdoc
   */
  static get pluginName() {
    return "TableAdvanced";
  }
}

/**
 * @private
 */
export default {
  TableAdvanced
};
