const path = require("path");
const webpack = require("webpack");
const TerserPlugin = require("terser-webpack-plugin");
const ckeditor5DllManifest = require("../../../../../../core/node_modules/ckeditor5/build/ckeditor5-dll.manifest.json");

module.exports = {
  mode: "production",
  optimization: {
    minimize: true,
    minimizer: [
      new TerserPlugin({
        terserOptions: {
          format: {
            comments: false
          }
        },
        test: /\.js(\?.*)?$/i,
        extractComments: false
      })
    ],
    moduleIds: "named"
  },
  entry: {
    path: path.resolve(__dirname, "src/index.js")
  },
  output: {
    path: path.resolve(__dirname, "../../build"),
    filename: "tableAdvanced.js",
    library: ["CKEditor5", "tableAdvanced"],
    libraryTarget: "umd",
    libraryExport: "default"
  },
  plugins: [
    new webpack.DllReferencePlugin({
      manifest: ckeditor5DllManifest,
      scope: "ckeditor5/src",
      name: "CKEditor5.dll"
    })
  ],
  module: {
    rules: [
      {
        test: /\.svg$/,
        type: "asset/source"
      }
    ]
  }
};
