# Editor Image Styles

The **Editor Image Styles** module lets you automatically apply Drupal image styles to images used inside text editors. It works with inline `<img>` tags as well as CSS `background-image` URLs, ensuring that your editor content serves optimized and consistently styled images.

This module integrates seamlessly with text editors like **CKEditor 5** and **Gutenberg**, giving site builders and content editors more control over how images are displayed in rich text fields.

---

## ✅ Features

* Applies Drupal image styles to inline images and background images.
* Configurable image style and base file path.
* Optional support for `background-image` styling.
* Works with any filter-enabled text editor (CKEditor 5, Gutenberg, etc.).

---

## 📦 Installation

You can install the module using **Composer**:

```bash
composer require drupal/editor_image_styles
```

Then enable it either through the **Extend** page (`/admin/modules`) or with Drush:

```bash
drush en editor_image_styles
```

---

## ⚙️ Configuration

Go to:
`Administration → Configuration → Content Authoring → Editor Image Styles`

### Available Settings

* **Image Style** – Select the image style to apply (e.g., `thumbnail`, `large`, `webp_large`).
* **Base Path** – Define the base path to detect images in content (default: `/sites/default/files/`).
* **Apply to Background Images** – Optionally enable styling for images used in CSS backgrounds.

---

## 🖊️ Usage with Text Editors

### CKEditor 5

1. Go to:
   `Admin → Configuration → Content Authoring → Text formats and editors`
2. Edit the text format you want to use (e.g., **Full HTML**).
3. In **Enabled filters**, check **Editor Image Styles**.
4. Save your configuration.

### Gutenberg

1. Go to:
   `Admin → Configuration → Content Authoring → Text formats and editors`
2. Edit the text format used by Gutenberg (e.g., `nextgencms_gutenberg`).
3. Enable the **Editor Image Styles** filter.
4. Make sure the filter order is correct (after HTML filtering, before cache filters).

---

## 📄 License

This project is licensed under the **GPL v2 (or later)**.
See the LICENSE.txt file for details.
