<?php

namespace Drupal\editor_image_styles\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\image\Entity\ImageStyle;

/**
 * Configuration form for Editor Image Styles.
 */
class EditorImageStylesConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['editor_image_styles.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'editor_image_styles_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('editor_image_styles.settings');

    $styles = ImageStyle::loadMultiple();
    $style_options = [];
    foreach ($styles as $style) {
      $style_options[$style->id()] = $style->label();
    }

    $form['image_style'] = [
      '#type' => 'select',
      '#title' => $this->t('Image style to apply'),
      '#description' => $this->t('Select the image style to apply to inline images.'),
      '#options' => $style_options,
      '#default_value' => $config->get('image_style'),
      '#required' => TRUE,
    ];

    $form['base_path'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Base path for image files'),
      '#description' => $this->t('Specify the base path used to identify image files in content. Default is /sites/default/files/.'),
      '#default_value' => $config->get('base_path') ?? '/sites/default/files/',
    ];

    $form['apply_to_background'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Apply image style to background images'),
      '#description' => $this->t('Enable this to apply the selected image style to background-image CSS styles.'),
      '#default_value' => $config->get('apply_to_background'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('editor_image_styles.settings')
      ->set('image_style', $form_state->getValue('image_style'))
      ->set('base_path', $form_state->getValue('base_path'))
      ->set('apply_to_background', $form_state->getValue('apply_to_background'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
