<?php

/**
 * @file
 * Views integration.
 */

use Drupal\views\Plugin\views\query\QueryPluginBase;
use Drupal\views\ViewExecutable;

/**
 * Implements hook_views_data().
 */
function editoria11y_views_data(): array {
  return [
    'editoria11y_pages' => [
      'table' => [
        'group' => t('Editoria11y'),
        'provider' => 'editoria11y',
        'base' => [
          'field' => 'ed11y_page',
          'title' => t('Editoria11y - Pages with issues'),
          'help' => t('Provides relationship for issues and dismissals', [], ['context' => 'problems']),
          'weight' => -10,
        ],
      ],
      'ed11y_page' => [
        'real field' => 'ed11y_page',
        'title' => t('EID'),
        'help' => t("Editoria11y's internal page ID"),
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'argument' => [
          'id' => 'numeric',
        ],
      ],
      'entity_id' => [
        'real field' => 'entity_id',
        'title' => t('Entity ID'),
        'help' => t('The NID/TID/UID of the page with an issue.'),
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'argument' => [
          'id' => 'numeric',
        ],
      ],
      'entity_type' => [
        'real field' => 'entity_type',
        'title' => t('Entity type'),
        'help' => t('The entity type; "route" if no type found.'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'in_operator',
          'options callback' => '\Drupal\editoria11y\Dashboard::getEntityTypeOptions',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'route_name' => [
        'real field' => 'route_name',
        'title' => t('Route name'),
        'help' => t('Route name for page.'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'string',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'page_path' => [
        'real field' => 'page_path',
        'title' => t('Page path'),
        'help' => t('Internal, relative page path.'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'string',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'langcode' => [
        'real field' => 'page_language',
        'title' => t('Page language'),
        'help' => t('Active translation.'),
        'field' => [
          'id' => 'language',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'string',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'page_title' => [
        'real field' => 'page_title',
        'title' => t('Page title'),
        'help' => t('The name of the route where this was last seen.'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'string',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'page_result_count' => [
        'real field' => 'page_result_count',
        'title' => t('Page result count'),
        'help' => t('The total number of issues on this page.', [], ['context' => 'problems']),
        'field' => [
          'id' => 'editoria11y_issues_by_page_link',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'argument' => [
          'id' => 'numeric',
        ],
      ],
      'updated' => [
        'real field' => 'updated',
        'title' => t('Updated'),
        'help' => t('When this page was last checked.'),
        'field' => [
          'id' => 'date',
        ],
        'sort' => [
          'id' => 'date',
        ],
        'filter' => [
          'id' => 'date',
        ],
      ],
    ],
    'editoria11y_results' => [
      'table' => [
        'group' => t('Editoria11y'),
        'provider' => 'editoria11y',
        'base' => [
          'field' => 'id',
          'title' => t('Editoria11y - Test results'),
          'help' => t('Stores Editoria11y issue list', [], ['context' => 'problems']),
          'weight' => -10,
        ],
      ],
      'id' => [
        'real field' => 'id',
        'title' => t('Result row'),
        'help' => t('Internal identifier'),
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'argument' => [
          'id' => 'numeric',
        ],
      ],
      'created' => [
        'real field' => 'created',
        'title' => t('Created'),
        'help' => t('When this page was flagged.'),
        'field' => [
          'id' => 'date',
        ],
        'sort' => [
          'id' => 'date',
        ],
        'filter' => [
          'id' => 'date',
        ],
      ],
      'result_name' => [
        'real field' => 'result_name',
        'title' => t('Result name'),
        'help' => t('The name of the test as reported by Editoria11y JS'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'standard',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'result_key' => [
        'real field' => 'result_key',
        'title' => t('Result name, linked'),
        'help' => t('Linked to report of all alerts of this type.'),
        'field' => [
          'id' => 'editoria11y_pages_by_issue_link',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'standard',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'result_name_count' => [
        'real field' => 'result_name_count',
        'title' => t('Result name count'),
        'help' => t('The number of hits for this test type on this page'),
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
      ],
    ],
    'editoria11y_dismissals' => [
      'table' => [
        'group' => t('Editoria11y'),
        'provider' => 'editoria11y',
        'base' => [
          'field' => 'id',
          'title' => t('Editoria11y - Dismissals'),
          'help' => t('Stores Editoria11y warnings and dismissals'),
          'weight' => -10,
        ],
      ],
      'id' => [
        'real field' => 'id',
        'title' => t('Dismissal internal reference ID'),
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
      ],
      'ed11y_page' => [
        'real field' => 'ed11y_page',
        'title' => t('Page with dismissal'),
        'help' => 'Page affected',
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'numeric',
        ],
        'sort' => [
          'id' => 'standard',
        ],
      ],
      'uid' => [
        'real field' => 'uid',
        'title' => t('Dismissed by'),
        'help' => t('The user linked to this dismissal.'),
        'relationship' => [
          'base' => 'users_field_data',
          'base field' => 'uid',
          'id' => 'standard',
          'label' => t('Linked Drupal user'),
        ],
        'field' => [
          'id' => 'numeric',
        ],
        'filter' => [
          'id' => 'user_name',
        ],
        'sort' => [
          'id' => 'standard',
        ],
      ],
      'element_id' => [
        'real field' => 'element_id',
        'title' => t('Dismissed element id'),
        'help' => t('Code sample to identify the flagged element.'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'string',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'created' => [
        'real field' => 'created',
        'title' => t('Dismissed on'),
        'help' => t('The Unix timestamp of the first time this record was flagged.'),
        'field' => [
          'id' => 'date',
        ],
        'sort' => [
          'id' => 'date',
        ],
        'filter' => [
          'id' => 'date',
        ],
      ],
      'stale_date' => [
        'real field' => 'stale_date',
        'title' => t('Dismissal stale since'),
        'help' => t('The element has not been seen since this date.'),
        'field' => [
          'id' => 'date',
        ],
        'sort' => [
          'id' => 'date',
        ],
        'filter' => [
          'id' => 'date',
        ],
      ],
      'result_name' => [
        'real field' => 'result_name',
        'title' => t('Dismissed result name'),
        'help' => t('The name of the test as reported by Editoria11y JS'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'standard',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'result_key' => [
        'real field' => 'result_key',
        'title' => t('Dismissed result name, linked'),
        'help' => t('Links to report of all alerts of this type.'),
        'field' => [
          'id' => 'editoria11y_dismissals_by_issue_link',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'string',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
      'dismissal_status' => [
        'real field' => 'dismissal_status',
        'title' => t('Dismissal status'),
        'help' => t('The type of dismissal (e.g., OK, Ignore)'),
        'field' => [
          'id' => 'standard',
        ],
        'sort' => [
          'id' => 'standard',
        ],
        'filter' => [
          'id' => 'in_operator',
          'options callback' => '\Drupal\editoria11y\Dashboard::getDismissalOptions',
        ],
        'argument' => [
          'id' => 'string',
        ],
      ],
    ],
  ];
}

/**
 * Implements hook_views_data_alter().
 */
function editoria11y_views_data_alter(array &$data): void {
  // Bidirectional relationships from ed11y_pages to nodes, terms and users.
  $data['editoria11y_pages']['editoria11y_node_to_page'] = [
    'title' => t('Relate from Editoria11y page to referenced node'),
    'help' => t('Issues were found on this node'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'node_field_data',
      // Database field name in example_table for the join.
      'base field' => 'nid',
      // Real database field name in foo for the join, to override.
      'field' => 'entity_id',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y page to referenced node'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues were found on this node'),
      'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.node.canonical',
        ],
      ],
    ],
  ];
  $data['node_field_data']['editoria11y_page_to_node'] = [
    'title' => t('Relate from node data to Editoria11y page'),
    'help' => t('Issues were found on this node'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_pages',
      // Database field name in example_table for the join.
      'base field' => 'entity_id',
      // Real database field name in foo for the join, to override.
      'field' => 'nid',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from node data to Editoria11y page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues were found on this node'),
      'extra' => [
        0 => [
          'field' => 'route_name',
          'value' => 'entity.node.canonical',
        ],
      ],
    ],
  ];
  $data['editoria11y_pages']['editoria11y_term_to_page'] = [
    'title' => t('Relate from Editoria11y page to referenced taxonomy term'),
    'help' => t('Issues were found on this term page'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'taxonomy_term_field_data',
      // Database field name in example_table for the join.
      'base field' => 'tid',
      // Real database field name in foo for the join, to override.
      'field' => 'entity_id',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y page to referenced taxonomy term'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues were found on this term page'),
      'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.taxonomy_term.canonical',
        ],
      ],
    ],
  ];
  $data['taxonomy_term_field_data']['editoria11y_page_to_term'] = [
    'title' => t('Relate from taxonomy term data to Editoria11y page'),
    'help' => t('Issues were found on this term page'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_pages',
      // Database field name in example_table for the join.
      'base field' => 'entity_id',
      // Real database field name in foo for the join, to override.
      'field' => 'tid',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from taxonomy term data to Editoria11y page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues were found on this term page'),
      'extra' => [
        0 => [
          'field' => 'route_name',
          'value' => 'entity.taxonomy_term.canonical',
        ],
      ],
    ],
  ];
  $data['editoria11y_pages']['editoria11y_user_to_page'] = [
    'title' => t('Relate from Editoria11y page list to user bio page data'),
    'help' => t('Issues were found on this user bio page'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'users_field_data',
      // Database field name in example_table for the join.
      'base field' => 'uid',
      // Real database field name in foo for the join, to override.
      'field' => 'entity_id',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y page to user bio page with issues'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues were found on this user bio page'),
      'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.user.canonical',
        ],
      ],
    ],
  ];
  $data['users_field_data']['editoria11y_page_to_user'] = [
    'title' => t('Relate from user bio page to Editoria11y results'),
    'help' => t('Issues were found on this user bio page'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_pages',
      // Database field name in example_table for the join.
      'base field' => 'entity_id',
      // Real database field name in foo for the join, to override.
      'field' => 'uid',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from users list to Editoria11y results on bio page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues were found on this user bio page'),
      'extra' => [
        0 => [
          'field' => 'route_name',
          'value' => 'entity.user.canonical',
        ],
      ],
    ],
  ];

  // Bidirectional relationships from ed11y_pages to results and dismissals.
  $data['editoria11y_pages']['editoria11y_page_to_results'] = [
    'title' => t('Relate from Editoria11y page to issues on page'),
    'help' => t('Issues found on this node'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_results',
      // Database field name in example_table for the join.
      'base field' => 'ed11y_page',
      // Real database field name in foo for the join, to override.
      'field' => 'ed11y_page',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y page to issues on page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues found on this node'),
      /*'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.node.canonical',
        ],
      ],*/
    ],
  ];
  $data['editoria11y_results']['editoria11y_result_to_page'] = [
    'title' => t('Relate from Editoria11y result to page'),
    'help' => t('Issues found on this node'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_pages',
      // Database field name in example_table for the join.
      'base field' => 'ed11y_page',
      // Real database field name in foo for the join, to override.
      'field' => 'ed11y_page',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y result to page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues found on this node'),
      /*'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.node.canonical',
        ],
      ],*/
    ],
  ];
  $data['editoria11y_pages']['editoria11y_dismissal_to_page'] = [
    'title' => t('Relate from Editoria11y page to dismissals on page'),
    'help' => t('Issues found on this node'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_dismissals',
      // Database field name in example_table for the join.
      'base field' => 'ed11y_page',
      // Real database field name in foo for the join, to override.
      'field' => 'ed11y_page',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y page to dismissals on page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues found on this node'),
      /*'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.node.canonical',
        ],
      ],*/
    ],
  ];
  $data['editoria11y_dismissals']['editoria11y_page_to_dismissals'] = [
    'title' => t('Relate from Editoria11y dismissal to page'),
    'help' => t('Issues found on this node'),
    'group' => 'Editoria11y',
    'relationship' => [
      // Views name of the table being joined to from foo.
      'base' => 'editoria11y_pages',
      // Database field name in example_table for the join.
      'base field' => 'ed11y_page',
      // Real database field name in foo for the join, to override.
      'field' => 'ed11y_page',
      // ID of relationship handler plugin to use.
      'id' => 'standard',
      'title' => t('Relate from Editoria11y dismissal to page'),
      // Description shown within the add relationship handler in the UI.
      'help' => t('Issues found on this node'),
      /*'extra' => [
        0 => [
          'left_field' => 'route_name',
          'value' => 'entity.node.canonical',
        ],
      ],*/
    ],
  ];
}

/**
 * Implements hook_views_query_alter().
 */
function editoria11y_views_query_alter(ViewExecutable $view, QueryPluginBase $query): void {
  $tableQueue = $query->getTableQueue();

  // Our relationships need entity ID, type and language. This adds the latter.
  foreach ($tableQueue as $queue) {
    if ($queue['join']) {
      if (str_starts_with($queue['join']->leftTable, 'editoria11y_pages')) {
        $leftTable = $queue['join']->leftTable;
        $table = $queue['alias'];
        $type = FALSE;
        switch ($queue['join']->table) {
          case 'node_field_data':
            $type = 'entity.node.canonical';
            break;

          case 'taxonomy_term_field_data':
            $type = 'entity.taxonomy_term.canonical';
            break;

          case 'users_field_data':
            $type = 'entity.user.canonical';
            break;
        }
        if ($table && $type) {
          // @todo 3.0 needs code review.
          $queue['join']->extra = $leftTable . ".page_language = " . $table . ".langcode AND " . $leftTable . ".route_name = '" . $type . "'";
        }
      }
      elseif ($queue['join']->table === 'editoria11y_pages') {
        $table = $queue['alias'];
        $leftTable = FALSE;
        $type = 'entity.node.canonical';
        switch ($queue['join']->leftTable) {
          case 'node_field_data':
            $leftTable = 'node_field_data';
            break;

          case 'taxonomy_term_field_data':
            $leftTable = 'taxonomy_term_field_data';
            $type = 'entity.taxonomy_term.canonical';
            break;

          case 'users_field_data':
            $leftTable = 'users_field_data';
            $type = 'entity.user.canonical';
            break;
        }
        if ($table && $leftTable) {
          $queue['join']->extra = $table . ".page_language = " . $leftTable . ".langcode AND " . $table . ".route_name = '" . $type . "'";
        }
      }
    }

  }
}
