<?php

namespace Drupal\editoria11y;

use Drupal\Core\Database\Connection;
use Drupal\Core\Database\StatementInterface;

/**
 * Handles database calls for DashboardController.
 */
class DismissalsOnPage {

  /**
   * Database property.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected Connection $database;

  /**
   * Constructs a new connection object.
   *
   * @param \Drupal\Core\Database\Connection $connection
   *   Database property.
   */
  public function __construct(Connection $connection) {
    $this->database = $connection;
  }

  /**
   * Function to get the dismissals.
   *
   * @param string $page_path
   *   Page path property.
   * @param string $page_language
   *   Page language code.
   *
   * @return \Drupal\Core\Database\StatementInterface|null
   *   Return the dismissals.
   */
  public function getDismissals(string $page_path, string $page_language): ?StatementInterface {

    $query = $this->database->select('editoria11y_pages', 'editoria11y_pages');
    $query->leftJoin('editoria11y_dismissals', 'editoria11y_dismissals', 'editoria11y_dismissals.ed11y_page = editoria11y_pages.ed11y_page');
    // 'page_path',
    $query->fields('editoria11y_dismissals',
      ['uid',
        'result_key',
        'element_id',
        'dismissal_status',
      ]
    );
    $query->fields('editoria11y_pages',
      ['ed11y_page']
    );
    $query->condition('editoria11y_pages.page_path', $page_path);
    $query->condition('editoria11y_pages.page_language', $page_language);
    return $query->execute();
  }

}
