<?php

namespace Drupal\editoria11y\Plugin\views\field;

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\GeneratedLink;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\views\Plugin\views\field\Standard;
use Drupal\views\Render\ViewsRenderPipelineMarkup;
use Drupal\views\ResultRow;

/**
 * Render a field as a link to the pages by issue view.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("editoria11y_dismissals_by_issue_link")
 */
class DismissalsByIssueLink extends Standard {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values): MarkupInterface|string|ViewsRenderPipelineMarkup|GeneratedLink {
    $value = parent::render($values);
    $label = $value;
    if (!empty($value)) {

      // @todo Abstract this out so I don't need to keep declaring it.
      $translated = [
        'altMeaningless' => $this->t('Alt text is meaningless'),
        'tableContainsContentHeading' => $this->t('Content heading inside a table'),
        'tableEmptyHeaderCell' => $this->t('Empty table header cell'),
        'headingEmpty' => $this->t('Heading tag without any text'),
        'altMissing' => $this->t('Image has no alternative text attribute'),
        'altDeadspace' => $this->t("Image's text alternative is unpronounceable"),
        'altEmptyLinked' => $this->t('Linked Image has no alt text'),
        'altURL' => $this->t("Linked image's text alternative is a URL"),
        'linkNoText' => $this->t('Link with no accessible text'),
        'tableNoHeaderCells' => $this->t('Table has no header cells'),
        'altNull' => $this->t('Manual check: image has no alt text'),
        'linkNewWindow' => $this->t('Manual check: is opening a new window expected?'),
        'blockquoteIsShort' => $this->t('Manual check: is this a blockquote?'),
        'embedAudio' => $this->t('Manual check: is an accurate transcript provided?'),
        'embedTwitter' => $this->t('Manual check: is this embed a keyboard trap?'),
        'embedCustom' => $this->t('Manual check: is this embedded content accessible?'),
        'linkTextIsGeneric' => $this->t('Manual check: is this link meaningful and concise?'),
        'linkTextIsURL' => $this->t('Manual check: is this link text a URL?'),
        'linkDocument' => $this->t('Manual check: is the linked document accessible?'),
        'textUppercase' => $this->t('Manual check: is this uppercase text needed?'),
        'embedVideo' => $this->t('Manual check: is this video accurately captioned?'),
        'embedVisualization' => $this->t('Manual check: is this visualization accessible?'),
        'altPartOfLinkWithText' => $this->t('Manual check: link contains both text and an image'),
        'headingIsLong' => $this->t('Manual check: long heading'),
        'altImageOf' => $this->t('Manual check: possibly redundant text in alt'),
        'textPossibleHeading' => $this->t('Manual check: should this be a heading?'),
        'textPossibleList' => $this->t('Manual check: should this have list formatting?'),
        'headingLevelSkipped' => $this->t('Manual check: was a heading level skipped?'),
        'altLong' => $this->t('Manual check: very long alternative text'),
      ];
      $strung = $value->__toString();
      if ($translated[$strung]) {
        $label = $translated[$strung];
      }
      elseif (isset($values->editoria11y_results_result_name)) {
        $label = $values->editoria11y_results_result_name;
      }

      $url = Url::fromUserInput("/admin/reports/editoria11y/dismissals/" . $strung);

      $value = Link::fromTextAndUrl($label, $url)->toString();

    }

    return $value;
  }

}
