<?php

namespace Drupal\editoria11y\Plugin\views\field;

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\GeneratedLink;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\views\Plugin\views\field\Standard;
use Drupal\views\Render\ViewsRenderPipelineMarkup;
use Drupal\views\ResultRow;

/**
 * Render a field as a link to the pages by issue view.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("editoria11y_issues_by_page_link")
 */
class IssuesByPageLink extends Standard {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values): MarkupInterface|string|ViewsRenderPipelineMarkup|GeneratedLink {
    $value = parent::render($values);
    if (!empty($value) && isset($values->ed11y_page)) {
      $label = $value;
      $url = Url::fromUserInput("/admin/reports/editoria11y/page", [
        'query' => [
          'id' => $values->ed11y_page,
        ],
      ]);

      $value = Link::fromTextAndUrl($label, $url)->toString();
    }

    return $value;
  }

}
