// Copied from https://editoria11y.princeton.edu/configuration/#customtests.
document.addEventListener('ed11yRunCustomTests', function() {
  // 1. Write your custom test. This can be anything you want.
  const brokenLinksSelector = drupalSettings.editoria11y.editoria11y_si.broken_links;
  const misspellings = drupalSettings.editoria11y.editoria11y_si.misspellings;
  const misspellingsArray = [];

  // Loop through misspellings to convert them to an array.
  misspellings.forEach((misspellingJsonString, index) => {
    // Parse the JSON string into an object.
    const misspelling = JSON.parse(misspellingJsonString);
    misspellingsArray[index] = {
      misspelledWord: misspelling.word,
      suggestionWord: misspelling.suggestion,
    };
  });

  const editoria11yContentRoot = drupalSettings.editoria11y.content_root;
  let readingScore = parseFloat(drupalSettings.editoria11y.editoria11y_si.reading_score);
  let readingScoreErrorGradeLevel = parseFloat(drupalSettings.editoria11y.editoria11y_si.reading_score_error_grade_level);
  const siteimproveUrl = drupalSettings.editoria11y.editoria11y_si.siteimprove_url;
  Ed11y.findElements('editoria11ySiBrokenLinks', brokenLinksSelector);
  Ed11y.findElements('editoria11ySiMisspellings', 'h1, h2, h3, h4, h5, h6, p, li, span, a, table');
  Ed11y.findElements('editoria11ySiReadingScore', editoria11yContentRoot + ' > :first-child');

  // 2. Create the content for your tip.
  Ed11y.M.editoria11ySiBrokenLinks = {
    // Provide a title and a body:
    title: 'Broken link',
    tip: (href) =>
        `<p>SiteImprove says the link is broken. Please update it.</p>
        <p>The specified URL is:<br>
        <em style='word-break: break-all;font-size:90%;line-height: 1.2;display: block;'>
            ${Ed11y.sanitizeForHTML(href)}
        </em></p>
        <div class="ed11y-tip-dismissals">
          <a href="${siteimproveUrl}" target="_blank">
            View SiteImprove page report
          </a>
        </div>`,
  };

  Ed11y.M.editoria11ySiMisspellings = {
    // Provide a title and a body:
    title: 'Misspellings',
    tip: (misspelledWord, suggestionWord) =>
        `<p>SiteImprove says there are misspellings on the page. See <a href="${siteimproveUrl}" target="_blank">SiteImprove page report</a> for more information.</p>
        <p>Misspelling: ${Ed11y.sanitizeForHTML(misspelledWord)}<br>Suggestion: ${Ed11y.sanitizeForHTML(suggestionWord)}</p>`,
  };

  Ed11y.M.editoria11ySiReadingScore = {
    // Provide a title and a body:
    title: 'Reading score',
    tip: () =>
        `<p>SiteImprove says the reading score is above the level set for the site. See <a href="${siteimproveUrl}" target="_blank">SiteImprove page report</a> for more information.</p>
        <p>The score of the page is: ${Ed11y.sanitizeForHTML(readingScore)}</p>
        <p>Grade level set for the site: ${Ed11y.sanitizeForHTML(readingScoreErrorGradeLevel)}</p>`,
  };

  // 3. Push each item you want flagged to Ed11y.results.
  Ed11y.elements.editoria11ySiBrokenLinks?.forEach((el) => {
    Ed11y.results.push({
      element: el,
      test: 'editoria11ySiBrokenLinks',
      content: Ed11y.M.editoria11ySiBrokenLinks.tip(el.getAttribute('href')),
      position: 'beforebegin',
      dismissalKey: Ed11y.dismissalKey(el?.getAttribute('href')),
    })
  })

  Ed11y.elements.editoria11ySiMisspellings?.forEach((el) => {
    thisText = Ed11y.getText(el);
    // Loop through the misspellings to find the one that matches the element text.
    misspellingsArray.forEach((misspelling, index) => {
      // Check if the element contains the misspellings content.
      if (thisText.includes(misspelling.misspelledWord)) {
        // If the misspelling is found, push the result.
        Ed11y.results.push({
          element: el,
          test: 'editoria11ySiMisspellings',
          content: Ed11y.M.editoria11ySiMisspellings.tip(misspelling.misspelledWord, misspelling.suggestionWord),
          position: 'beforebegin',
          dismissalKey: misspelling.misspelledWord,
        })
      }
    });
  })

  Ed11y.elements.editoria11ySiReadingScore?.forEach((el) => {
    if (readingScore > readingScoreErrorGradeLevel) {
      Ed11y.results.push({
        element: el,
        test: 'editoria11ySiReadingScore',
        content: Ed11y.M.editoria11ySiReadingScore.tip(),
        position: 'beforebegin',
        dismissalKey: readingScore,
      })
    }
  })

  // 4. When you are done with all your custom tests, dispatch an "ed11yResume" event:
  let allDone = new CustomEvent('ed11yResume');
  document.dispatchEvent(allDone);
})
