<?php

declare(strict_types=1);

namespace Drupal\editoria11y_si\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityChangedTrait;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\editoria11y_si\Editoria11ySiInterface;

/**
 * Defines the editoria11y_si entity class.
 *
 * @ContentEntityType(
 *   id = "editoria11y_si",
 *   label = @Translation("editoria11y_si"),
 *   label_collection = @Translation("editoria11y_sis"),
 *   label_singular = @Translation("editoria11y_si"),
 *   label_plural = @Translation("editoria11y_sis"),
 *   label_count = @PluralTranslation(
 *     singular = "@count editoria11y_sis",
 *     plural = "@count editoria11y_sis",
 *   ),
 *   handlers = {
 *     "views_data" = "Drupal\views\EntityViewsData",
 *   },
 *   base_table = "editoria11y_si",
 *   admin_permission = "administer editoria11y_si",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "id",
 *     "uuid" = "uuid",
 *   },
 * )
 */
final class Editoria11ySi extends ContentEntityBase implements Editoria11ySiInterface {

  use EntityChangedTrait;

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {

    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['status'] = BaseFieldDefinition::create('boolean')
      ->setLabel(t('Status'))
      ->setDefaultValue(TRUE)
      ->setSetting('on_label', 'Enabled')
      ->setDisplayOptions('form', [
        'type' => 'boolean_checkbox',
        'settings' => [
          'display_label' => FALSE,
        ],
        'weight' => 0,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayOptions('view', [
        'type' => 'boolean',
        'label' => 'above',
        'weight' => 0,
        'settings' => [
          'format' => 'enabled-disabled',
        ],
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Authored on'))
      ->setDescription(t('The time that the editoria11y_si was created.'))
      ->setDisplayOptions('view', [
        'label' => 'above',
        'type' => 'timestamp',
        'weight' => 20,
      ])
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayOptions('form', [
        'type' => 'datetime_timestamp',
        'weight' => 20,
      ])
      ->setDisplayConfigurable('view', TRUE);

    $fields['changed'] = BaseFieldDefinition::create('changed')
      ->setLabel(t('Changed'))
      ->setDescription(t('The time that the editoria11y_si was last edited.'));

    $fields['url'] = BaseFieldDefinition::create('string')
      ->setLabel(t('URL'))
      ->setDefaultValue(NULL)
      ->setDescription(t('Page URL from SiteImprove.'))
      ->setSettings([
        'max_length' => 255,
        'text_processing' => 0,
      ]);

    $fields['siteimprove_url'] = BaseFieldDefinition::create('string')
      ->setLabel(t('SiteImprove URL'))
      ->setDefaultValue(NULL)
      ->setDescription(t('SiteImprove page to review issues.'))
      ->setSettings([
        'max_length' => 255,
        'text_processing' => 0,
      ]);

    // content_hash.
    $fields['content_hash'] = BaseFieldDefinition::create('string')
      ->setLabel(t('content_hash'))
      ->setDefaultValue(NULL)
      ->setDescription(t('Content hash of the $data to check if anything has changed using Crypt::hashBase64.'))
      ->setSettings([
        'max_length' => 255,
        'text_processing' => 0,
      ]);

    $fields['siteimprove_type'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Type of data from SiteImprove'))
      ->setDescription(t('Used to help filter if this is a broken link, or down the road, a misspelling.'))
      ->setSettings([
        'max_length' => 255,
        'text_processing' => 0,
      ])
      // Set no default value.
      ->setDefaultValue(NULL);

    // Raw data from siteimprove.
    $fields['raw_data'] = BaseFieldDefinition::create('string_long')
      ->setLabel(t('Raw SiteImprove Data'))
      ->setDescription(t('Data from SiteImprove that was saved as raw JSON.'));

    return $fields;
  }

}
