<?php

namespace Drupal\editoria11y_si\Plugin\KeyInput;

use Drupal\Core\Form\FormStateInterface;
use Drupal\key\Plugin\KeyInputBase;

/**
 * Defines a key input for Editoria11y SI.
 *
 * @KeyInput(
 *   id = "editoria11y_si",
 *   label = @Translation("SiteImprove credentials for Editoria11y."),
 *   description = @Translation("A collection of fields to store SiteImprove credentials.")
 * )
 */
class Editoria11ySiKeyInput extends KeyInputBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'username' => '',
      'api_key' => '',
      'site' => '',
      'group' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(
    array $form,
    FormStateInterface $form_state,
  ) {
    return $form + [
      'username' => [
        '#type' => 'textfield',
        '#default_value' => $this->configuration['username'],
        '#title' => $this->t('Username'),
        '#required' => TRUE,
      ],
      'api_key' => [
        '#type' => 'textfield',
        '#default_value' => $this->configuration['api_key'],
        '#title' => $this->t('API Key'),
        '#required' => TRUE,
      ],
      'site' => [
        '#type' => 'textfield',
        '#default_value' => $this->configuration['site'],
        '#title' => $this->t('Site'),
        '#required' => TRUE,
      ],
      'group' => [
        '#type' => 'textfield',
        '#default_value' => $this->configuration['group'],
        '#title' => $this->t('Group'),
      ],
    ];
  }

}
