<?php

namespace Drupal\editoria11y_si\Plugin\KeyType;

use Drupal\Core\Form\FormStateInterface;
use Drupal\key\Plugin\KeyType\AuthenticationMultivalueKeyType;

/**
 * Defines a key for SiteImprove credentials.
 *
 * @KeyType(
 *   id = "editoria11y_si_key",
 *   label = @Translation("Editoria11y SiteImprove"),
 *   description = @Translation("SiteImprove credentials for Editoria11y. See SiteImprove API documentation at https://my2.siteimprove.com/Integrations/Api/ManageApiKeys for more information."),
 *   group = "authentication",
 *   key_value = {
 *     "plugin" = "editoria11y_si"
 *   },
 *   multivalue = {
 *     "enabled" = true,
 *     "fields" = {
 *       "username" = {
 *         "label" = @Translation("Username"),
 *         "required" = true,
 *       },
 *       "api_key" = {
 *         "label" = @Translation("API Key"),
 *         "required" = true,
 *       },
 *      "site" = {
 *         "label" = @Translation("Site"),
 *         "required" = true,
 *       },
 *       "group" = {
 *         "label" = @Translation("Group"),
 *         "required" = false,
 *       },
 *     }
 *   }
 * )
 */
class Editoria11ySiKeyType extends AuthenticationMultivalueKeyType {

  /**
   * {@inheritdoc}
   */
  public function validateKeyValue(
    array $form,
    FormStateInterface $form_state,
    $key_value,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  public static function generateKeyValue(array $configuration) {
    return json_encode([
      'username' => '',
      'api_key' => '',
      'site' => '',
      'group' => '',
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function serialize(array $array) {
    return json_encode($array);
  }

  /**
   * {@inheritdoc}
   */
  public function unserialize($value) {
    return json_decode($value, TRUE);
  }

}
