<?php

namespace Drupal\ejectorseat\Form;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Datetime\DateFormatterInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Administration settings form for Ejector Seat module.
 */
class EjectorseatSettings extends ConfigFormBase implements ContainerInjectionInterface {

  /**
   * Date formatter service.
   *
   * @var \Drupal\Core\Datetime\DateFormatterInterface
   */
  protected $dateFormatter;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ejectorseat_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['ejectorseat.settings'];
  }

  /**
   * Create a new EjectorseatSettings object.
   */
  public function __construct(DateFormatterInterface $date_formatter) {
    $this->dateFormatter = $date_formatter;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static($container->get('date.formatter'));
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $this->config('ejectorseat.settings')
      ->set('interval', $form_state->getValue('interval'))
      ->set('background', $form_state->getValue('background'))
      ->save();

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('ejectorseat.settings');

    $time_options = [15, 30, 60, 120, 180, 300, 600, 1200, 1800, 3600];
    $formatted_options = [$this->t('disabled')] + array_map(
      [$this->dateFormatter, 'formatInterval'],
      array_combine($time_options, $time_options)
    );
    $form['interval'] = [
      '#type' => 'select',
      '#title' => $this->t('Login status check rate'),
      '#options' => $formatted_options,
      '#description' => $this->t("How often should Ejector Seat check to see if a user has been logged out? Lower rates may affect site performance."),
      '#default_value' => $config->get('interval'),
    ];

    $form['background'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Run check in background'),
      '#description' => $this->t('By default for better server performance, only check login status when the browser window or tab is active. For better security but worse performance, run check in background even when browser window or tab is in the background. Each login status check requires a server request returning the status.'),
      '#default_value' => $config->get('background'),
    ];

    return parent::buildForm($form, $form_state);
  }

}
