<?php

namespace Drupal\ejectorseat\Controller;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Session\AccountProxy;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Default controller for the ejectorseat module.
 */
class DefaultController implements ContainerInjectionInterface {

  /**
   * The current active user.
   *
   * @var \Drupal\Core\Session\AccountProxy
   */
  protected $currentUser;

  /**
   * Create a new DefaultController object.
   */
  public function __construct(AccountProxy $current_user) {
    $this->currentUser = $current_user;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static($container->get('current_user'));
  }

  /**
   * Check if user is logged in.
   */
  public function checkUserLoggedIn() {
    return new JsonResponse($this->currentUser->isAuthenticated() ? '1' : '0');
  }

}
