<?php

namespace Drupal\elastic_email\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\elastic_email\Plugin\Mail\ElasticEmailMailSystem;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Processes Mail Queue for Elastic Email.
 *
 * @QueueWorker(
 *   id = "elastic_email_process_queue",
 *   title = @Translation("Elastic Email Process Queue"),
 *   cron = {"time" = 5}
 * )
 */
class ElasticEmailProcessQueue extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * Mail sender.
   *
   * @var \Drupal\elastic_email\Plugin\Mail\ElasticEmailMailSystem
   */
  protected ElasticEmailMailSystem $sender;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('plugin.manager.mail')->createInstance('elastic_email_mail')
    );
  }

  /**
   * {@inheritdoc}
   */
  final public function __construct(array $configuration, $plugin_id, $plugin_definition, ElasticEmailMailSystem $sender) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->sender = $sender;
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data): void {
    $this->sender->send($data);
  }

}
