/* eslint-disable camelcase */
((Drupal, $) => {
  Drupal.behaviors.ECIndexDialog = {
    attach(context) {
      // eslint-disable-next-line func-names
      $('a.ec-index-dialog').once('ec-index-dialog', function () {
        // eslint-disable-next-line func-names
        $(this).click(function () {
          Drupal.ECIndexDialog.open($(this).attr('href'), $(this).html());
          // eslint-disable-next-line func-names
          Drupal.ECIndexDialog.populateIndex = function (
            cluster_id,
            index_name,
            settings,
          ) {
            // Add new option and select it.
            // eslint-disable-next-line no-jquery/no-val
            $(`#${settings.index_element_id}`)
              .append(`<option value="${index_name}">${index_name}</option>`)
              .val(index_name);

            // Trigger change to update the form cache.
            $(`#${settings.cluster_element_id}`).trigger('change');
          };

          return false;
        }, context);
      });
    },
  };

  /**
   * Our dialog object. Can be used to open a dialog to anywhere.
   */
  Drupal.ECIndexDialog = {
    dialog_open: false,
    open_dialog: null,
  };

  /**
   * If this property is set to be a function, it
   * will be called when an entity is received from an overlay.
   */
  Drupal.ECIndexDialog.populateIndex = null;

  /**
   * Open a dialog window.
   *
   * @param {string} href
   *   The location of the page to display in the dialog window.
   * @param {string} title
   *   The title of the dialog window.
   */
  // eslint-disable-next-line func-names
  Drupal.ECIndexDialog.open = function (href, title) {
    if (!this.dialog_open) {
      // Get the current window size and do 75% of the width and 90% of the height.
      // @todo Add settings for this so that users can configure this by themselves.
      const window_width = ($(window).width() / 100) * 75;
      const window_height = ($(window).height() / 100) * 90;
      this.open_dialog = $(
        `<iframe class="elasticsearch-dialog-iframe" src="${href}"></iframe>`,
      )
        .dialog({
          width: window_width,
          height: window_height,
          modal: true,
          resizable: false,
          position: ['center', 50],
          title,
          close() {
            Drupal.ECIndexDialog.dialog_open = false;
          },
        })
        .width(window_width - 10)
        .height(window_height);
      // eslint-disable-next-line func-names, no-jquery/no-bind
      $(window).bind('resize scroll', function () {
        // Move the dialog the main window moves.
        if (
          typeof Drupal.ECIndexDialog === 'object' &&
          Drupal.ECIndexDialog.open_dialog != null
        ) {
          Drupal.ECIndexDialog.open_dialog.dialog('option', 'position', [
            'center',
            10,
          ]);
          Drupal.ECIndexDialog.setDimensions();
        }
      });
      this.dialog_open = true;
    }
  };

  /**
   * Set dimensions of the dialog depending on the current window size
   * and scroll position.
   */
  // eslint-disable-next-line func-names
  Drupal.ECIndexDialog.setDimensions = function () {
    if (typeof Drupal.ECIndexDialog === 'object') {
      const window_width = ($(window).width() / 100) * 75;
      const window_height = ($(window).height() / 100) * 90;
      this.open_dialog
        .dialog('option', 'width', window_width)
        .dialog('option', 'height', window_height)
        .width(window_width - 10)
        .height(window_height);
    }
  };

  /**
   * Close the dialog and provide an entity id and a title
   * that we can use in various ways.
   *
   * @param {string} cluster_id
   *   The ID of the Elasticsearch Connector cluster.
   * @param {string} index_name
   *   The ID of the Search API Index.
   * @param {object} settings
   *   Object holding settings for the dialog.
   */
  // eslint-disable-next-line func-names
  Drupal.ECIndexDialog.close = function (cluster_id, index_name, settings) {
    this.open_dialog.dialog('close');
    this.open_dialog.dialog('destroy');
    this.open_dialog = null;
    this.dialog_open = false;
    // Call our populateIndex function if we have one.
    // this is used as an event.
    if (typeof this.populateIndex === 'function') {
      this.populateIndex(cluster_id, index_name, settings);
    }
  };
})(Drupal, jQuery);
