<?php

namespace Drupal\elasticsearch_connector\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Allow other modules to alter the index params before we send them.
 *
 * @package Drupal\elasticsearch_connector\Event
 */
class BuildIndexParamsEvent extends Event {

  /**
   * An identifier for this event.
   *
   * @var string
   */
  const BUILD_PARAMS = 'elasticsearch_connector.build_indexparams';

  /**
   * Array of params to send along to Elasticsearch to perform the bulk index.
   *
   * @var array
   */
  protected $params;

  /**
   * The name of the index on the Elasticsearch server.
   *
   * Includes a prefix for uniqueness, the database name, and index machine
   * name.
   *
   * @var string
   */
  protected $indexName;

  /**
   * BuildIndexParamsEvent constructor.
   *
   * @param array $params
   *   Array of params to send along to Elasticsearch to perform the bulk index.
   * @param string $indexName
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function __construct($params, $indexName) {
    $this->params = $params;
    $this->indexName = $indexName;
  }

  /**
   * Getter for the params config array.
   *
   * @return array
   *   Array of params to send along to Elasticsearch to perform the bulk index.
   */
  public function getElasticIndexParams() {
    return $this->params;
  }

  /**
   * Setter for the params config array.
   *
   * @param array $params
   *   Array of params to send along to Elasticsearch to perform the bulk index.
   */
  public function setElasticIndexParams($params) {
    $this->params = $params;
  }

  /**
   * Getter for the index name.
   *
   * @return string
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function getIndexName() {
    return $this->indexName;
  }

}
