<?php

namespace Drupal\elasticsearch_connector\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Allow other modules to alter the search params before we create it.
 *
 * @package Drupal\elasticsearch_connector\Event
 */
class BuildSearchParamsEvent extends Event {

  /**
   * An identifier for this event.
   *
   * @var string
   */
  const BUILD_QUERY = 'elasticsearch_connector.build_searchparams';

  /**
   * Array of parameters to send along to the Elasticsearch _search endpoint.
   *
   * @var array
   */
  protected $params;

  /**
   * The name of the index on the Elasticsearch server.
   *
   * Includes a prefix for uniqueness, the database name, and index machine
   * name.
   *
   * @var string
   */
  protected $indexName;

  /**
   * BuildSearchParamsEvent constructor.
   *
   * @param array $params
   *   Array of parameters to send along to the Elasticsearch _search endpoint.
   * @param string $indexName
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function __construct($params, $indexName) {
    $this->params = $params;
    $this->indexName = $indexName;
  }

  /**
   * Getter for the params config array.
   *
   * @return array
   *   Array of parameters to send along to the Elasticsearch _search endpoint.
   */
  public function getElasticSearchParams() {
    return $this->params;
  }

  /**
   * Setter for the params config array.
   *
   * @param array $params
   *   Array of parameters to send along to the Elasticsearch _search endpoint.
   */
  public function setElasticSearchParams($params) {
    $this->params = $params;
  }

  /**
   * Getter for the index name.
   *
   * @return string
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function getIndexName() {
    return $this->indexName;
  }

}
