<?php

namespace Drupal\elasticsearch_connector\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Allow other modules to alter the index config before we create it.
 *
 * @package Drupal\elasticsearch_connector\Event
 */
class PrepareIndexEvent extends Event {

  /**
   * An identifier for this event.
   *
   * @var string
   */
  const PREPARE_INDEX = 'elasticsearch_connector.prepare_index';

  /**
   * Parameters required to create an index.
   *
   * @var array
   */
  protected $indexConfig;

  /**
   * The name of the index on the Elasticsearch server.
   *
   * Includes a prefix for uniqueness, the database name, and index machine
   * name.
   *
   * @var string
   */
  protected $indexName;

  /**
   * PrepareIndexEvent constructor.
   *
   * @param array $indexConfig
   *   Parameters required to create an index.
   * @param string $indexName
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function __construct($indexConfig, $indexName) {
    $this->indexConfig = $indexConfig;
    $this->indexName = $indexName;
  }

  /**
   * Getter for the index config array.
   *
   * @return array
   *   Parameters required to create an index.
   */
  public function getIndexConfig() {
    return $this->indexConfig;
  }

  /**
   * Setter for the index config array.
   *
   * @param array $indexConfig
   *   Parameters required to create an index.
   */
  public function setIndexConfig($indexConfig) {
    $this->indexConfig = $indexConfig;
  }

  /**
   * Getter for the index name.
   *
   * @return string
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function getIndexName() {
    return $this->indexName;
  }

}
