<?php

namespace Drupal\elasticsearch_connector\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Allow other modules to alter the index mapping before we create it.
 *
 * @package Drupal\elasticsearch_connector\Event
 */
class PrepareIndexMappingEvent extends Event {

  /**
   * An identifier for this event.
   *
   * @var string
   */
  const PREPARE_INDEX_MAPPING = 'elasticsearch_connector.prepare_index_mapping';

  /**
   * Parameters required to create an index mapping.
   *
   * @var array
   */
  protected $indexMappingParams;

  /**
   * The name of the index on the Elasticsearch server.
   *
   * Includes a prefix for uniqueness, the database name, and index machine
   * name.
   *
   * @var string
   */
  protected $indexName;

  /**
   * PrepareIndexMappingEvent constructor.
   *
   * @param array $indexMappingParams
   *   Parameters required to create an index mapping.
   * @param string $indexName
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function __construct($indexMappingParams, $indexName) {
    $this->indexMappingParams = $indexMappingParams;
    $this->indexName = $indexName;
  }

  /**
   * Getter for the index params array.
   *
   * @return array
   *   Parameters required to create an index mapping.
   */
  public function getIndexMappingParams() {
    return $this->indexMappingParams;
  }

  /**
   * Setter for the index params array.
   *
   * @param array $indexMappingParams
   *   Parameters required to create an index mapping.
   */
  public function setIndexMappingParams($indexMappingParams) {
    $this->indexMappingParams = $indexMappingParams;
  }

  /**
   * Getter for the index name.
   *
   * @return string
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function getIndexName() {
    return $this->indexName;
  }

}
