<?php

namespace Drupal\elasticsearch_connector\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Allow other modules to alter mapping config before we create it.
 *
 * @package Drupal\elasticsearch_connector\Event
 */
class PrepareMappingEvent extends Event {

  /**
   * An identifier for this event.
   *
   * @var string
   */
  const PREPARE_MAPPING = 'elasticsearch_connector.prepare_mapping';

  /**
   * An array of mapping configuration.
   *
   * @var array
   */
  protected $mappingConfig;

  /**
   * The Search API data type of this field.
   *
   * @var string
   */
  protected $type;

  /**
   * An indexed field for the current index.
   *
   * @var \Drupal\search_api\Item\FieldInterface
   */
  protected $field;

  /**
   * PrepareMappingEvent constructor.
   *
   * @param array $mappingConfig
   *   An array of mapping configuration.
   * @param string $type
   *   The Search API data type of this field.
   * @param \Drupal\search_api\Item\FieldInterface $field
   *   An indexed field for the current index.
   */
  public function __construct($mappingConfig, $type, $field) {
    $this->mappingConfig = $mappingConfig;
    $this->type = $type;
    $this->field = $field;
  }

  /**
   * Getter for the mapping config array.
   *
   * @return array
   *   An array of mapping configuration.
   */
  public function getMappingConfig() {
    return $this->mappingConfig;
  }

  /**
   * Setter for the mapping config array.
   *
   * @param array $mappingConfig
   *   An array of mapping configuration.
   */
  public function setMappingConfig($mappingConfig) {
    $this->mappingConfig = $mappingConfig;
  }

  /**
   * Getter for the mapping type.
   *
   * @return string
   *   The Search API data type of this field.
   */
  public function getMappingType() {
    return $this->type;
  }

  /**
   * Getter for the field.
   *
   * @return \Drupal\search_api\Item\FieldInterface
   *   An indexed field for the current index.
   */
  public function getMappingField() {
    return $this->field;
  }

}
