<?php

namespace Drupal\elasticsearch_connector\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Allow other modules to alter the search query before we create it.
 *
 * @package Drupal\elasticsearch_connector\Event
 */
class PrepareSearchQueryEvent extends Event {

  /**
   * An identifier for this event.
   *
   * @var string
   */
  const PREPARE_QUERY = 'elasticsearch_connector.prepare_searchquery';

  /**
   * The search query.
   *
   * An associative array with the following keys:
   * - query_offset: Pager offset.
   * - query_limit: Number of items to return in the query.
   * - query_search_string: Main full text query.
   * - query_search_filter: Filters.
   * - sort: Sort options.
   * - mlt: More like this search options.
   *
   * @var array
   */
  protected $elasticSearchQuery;

  /**
   * The name of the index on the Elasticsearch server.
   *
   * Includes a prefix for uniqueness, the database name, and index machine
   * name.
   *
   * @var string
   */
  protected $indexName;

  /**
   * PrepareSearchQueryEvent constructor.
   *
   * @param array $elasticSearchQuery
   *   The search query. An associative array with the following keys:
   *   - query_offset: Pager offset.
   *   - query_limit: Number of items to return in the query.
   *   - query_search_string: Main full text query.
   *   - query_search_filter: Filters.
   *   - sort: Sort options.
   *   - mlt: More like this search options.
   * @param string $indexName
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function __construct($elasticSearchQuery, $indexName) {
    $this->elasticSearchQuery = $elasticSearchQuery;
    $this->indexName = $indexName;
  }

  /**
   * Getter for the elasticSearchQuery config array.
   *
   * @return array
   *   The search query. An associative array with the following keys:
   *   - query_offset: Pager offset.
   *   - query_limit: Number of items to return in the query.
   *   - query_search_string: Main full text query.
   *   - query_search_filter: Filters.
   *   - sort: Sort options.
   *   - mlt: More like this search options.
   */
  public function getElasticSearchQuery() {
    return $this->elasticSearchQuery;
  }

  /**
   * Setter for the elasticSearchQuery config array.
   *
   * @param array $elasticSearchQuery
   *   The search query. An associative array with the following keys:
   *   - query_offset: Pager offset.
   *   - query_limit: Number of items to return in the query.
   *   - query_search_string: Main full text query.
   *   - query_search_filter: Filters.
   *   - sort: Sort options.
   *   - mlt: More like this search options.
   */
  public function setElasticSearchQuery($elasticSearchQuery) {
    $this->elasticSearchQuery = $elasticSearchQuery;
  }

  /**
   * Getter for the index name.
   *
   * @return string
   *   The name of the index on the Elasticsearch server. Includes a prefix for
   *   uniqueness, the database name, and index machine name.
   */
  public function getIndexName() {
    return $this->indexName;
  }

}
