<?php

namespace Drupal\elasticsearch_search_api;

use nodespark\DESConnector\ClientInterface;

/**
 * Class SynonymSync.
 */
interface SyncStrategyInterface {

  /**
   * Sync the data with the index.
   *
   * @param \nodespark\DESConnector\ClientInterface $client
   *   The Elasticsearch client.
   * @param array $settingsParams
   *   An array of settings parameters.
   * @param array $mappingParams
   *   An Array of mapping parameters.
   *
   * @return bool
   *   TRUE if the sync is successful.
   */
  public function execute(ClientInterface $client, array $settingsParams = [], array $mappingParams = []);

}
