<?php

namespace Drupal\elasticsearch_search_api\Utility;

use Drupal\Core\Entity\Entity\EntityViewDisplay;
use Drupal\node\NodeTypeInterface;

/**
 * Provides specific helper methods.
 */
class UtilityHelper {

  /**
   * Helper function to extract a quoted string from a search term.
   *
   * @param string $keyword
   *   A search term.
   *
   * @return array
   *   An array of quoted string matches.
   */
  public static function extractQuotedString(&$keyword) {
    preg_match_all('/\"([^\"]*?)\"/', $keyword, $matches);
    foreach ($matches[0] as $phrase) {
      $keyword = str_replace($phrase, '', $keyword);
      $keyword = trim($keyword);
    }
    return $matches[1];
  }

  /**
   * Helper function to add 'search_index' view mode to the given content type.
   *
   * @param \Drupal\node\NodeTypeInterface $content_type
   *   A content type machine name.
   */
  public static function configureSearchIndexViewMode(NodeTypeInterface $content_type) {
    $display = EntityViewDisplay::load("node.{$content_type->id()}.search_index");

    // If there is already a 'search_index' view mode
    // defined for this content type, don't alter it.
    if ($display instanceof EntityViewDisplay) {
      return;
    }

    // Create & enable the view display.
    $display = EntityViewDisplay::create([
      'targetEntityType' => 'node',
      'bundle' => $content_type->id(),
      'mode' => 'search_index',
    ]);

    // Remove all default components, except title.
    foreach (array_keys($display->getComponents()) as $name) {
      if ($name !== 'title') {
        $display->removeComponent($name);
      }
    }

    $display->enable();
    $display->save();

    \Drupal::logger('elasticsearch_search_api')->notice("Display {$display->id()} was added.");
  }

}
