/**
 * @file
 * JavaScript behaviors for element multiple.
 */

(function ($, Drupal, once) {
  /**
   * Move show weight to after the table.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.elementMultipleTableDrag = {
    attach(context, settings) {
      const tableDragSettings = settings.tableDrag || {};
      Object.keys(tableDragSettings).forEach((base) => {
        const selector = `.js-form-type-element-multiple #${base}`;
        $(once('element-multiple-table-drag', selector, context)).each(
          function () {
            const $tableDrag = $(this);
            const $toggleWeight = $tableDrag
              .prev()
              .prev('.tabledrag-toggle-weight-wrapper');
            if ($toggleWeight.length) {
              $toggleWeight.addClass(
                'element-multiple-tabledrag-toggle-weight',
              );
              $tableDrag.after($toggleWeight);
            }
          },
        );
      });
    },
  };

  /**
   * Submit multiple add number input value when enter is pressed.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.elementMultipleAdd = {
    attach(context, settings) {
      $(once('element-multiple-add', '.js-element-multiple-add', context)).each(
        function () {
          const $submit = $(this).find('input[type="submit"], button');
          const $number = $(this).find('input[type="number"]');
          $number.keyup(function (event) {
            if (event.which === 13) {
              // Note: Mousedown is the default trigger for Ajax events.
              // @see Drupal.Ajax.
              $submit.trigger('mousedown');
            }
          });
        },
      );
    },
  };
})(jQuery, Drupal, once);
