<?php

namespace Drupal\email_otp_login;

use Drupal\Core\Mail\MailManagerInterface;
use Drupal\Core\Language\LanguageManagerInterface;

/**
 *
 */
class Mailer {

  protected $mailManager;
  protected $languageManager;

  public function __construct(MailManagerInterface $mail_manager, LanguageManagerInterface $language_manager) {
    $this->mailManager = $mail_manager;
    $this->languageManager = $language_manager;
  }

  /**
   * Send OTP email to the user.
   */
  public function sendOtpEmail($email, $otp) {
    $module = 'email_otp_login';
    $key = 'otp_email';
    $params = ['otp' => $otp];
    $langcode = $this->languageManager->getDefaultLanguage()->getId();
    $send = TRUE;

    // Send the email.
    $this->mailManager->mail($module, $key, $email, $langcode, $params, NULL, $send);
  }

}
