<?php

namespace Drupal\email_otp_login\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\email_otp_login\MailerService;
use Drupal\email_otp_login\OtpGeneratorService;

/**
 *
 */
class OtpLoginController extends ControllerBase {

  protected $otpMailer;
  protected $otpGenerator;

  public function __construct(MailerService $mailer, OtpGeneratorService $otpGenerator) {
    $this->otpMailer = $mailer;
    $this->otpGenerator = $otpGenerator;
  }

  /**
   *
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('email_otp_login.mailer'),
      $container->get('email_otp_login.generator')
    );
  }

  /**
   * Generate OTP and send to user's email.
   */
  public function generateOtp() {
    $user = \Drupal::currentUser();
    $email = $user->getEmail();
    $otp = $this->otpGenerator->generateOtp();

    // Send OTP to user's email.
    $this->otpMailer->sendOtpEmail($email, $otp);

    // Store OTP temporarily.
    \Drupal::state()->set('otp_code_' . $email, $otp);

    // Redirect to login page.
    return $this->redirect('user.login');
  }

}
