<?php

namespace Drupal\email_otp_login\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 *
 */
class OtpValidation extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'otp_validation_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Get the email passed via URL.
    $email = \Drupal::routeMatch()->getParameter('email');

    $form['otp'] = [
      '#type' => 'password',
      '#title' => $this->t('Enter OTP'),
      '#description' => $this->t('Please enter the OTP sent to your email.'),
      '#required' => TRUE,
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit OTP'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $email = \Drupal::routeMatch()->getParameter('email');
    $otp_entered = $form_state->getValue('otp');

    // Get OTP stored in session or state.
    $stored_otp = \Drupal::state()->get('otp_code_' . $email);

    // Validate OTP.
    if ($otp_entered == $stored_otp) {
      // OTP is valid, log in the user.
      $user = user_load_by_mail($email);
      if ($user) {
        user_login_finalize($user);
        // Delete OTP after use.
        \Drupal::state()->delete('otp_code_' . $email);

        // Show success message.
        \Drupal::messenger()->addMessage($this->t('OTP validated successfully. You are now logged in.'));

        // Redirect to the user's profile page.
        $profile_url = Url::fromRoute('entity.user.canonical', ['user' => $user->id()]);
        // Redirect to the user profile.
        $form_state->setRedirectUrl($profile_url);
      }
      else {
        \Drupal::messenger()->addError($this->t('No user found for this email.'));
      }
    }
    else {
      \Drupal::messenger()->addError($this->t('Invalid OTP.'));
    }
  }

}
