<?php

namespace Drupal\email_otp_login\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\email_otp_login\MailerService;
use Drupal\email_otp_login\OtpGeneratorService;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\State\State;


/**
 *
 */
class OtpLoginController extends ControllerBase {

  protected $otpMailer;
  protected $otpGenerator;

  /**
   * The current user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $currentUser;

  /**
   * The state.
   *
   * @var \Drupal\Core\State\StateInterface
   */
  protected $state;

  /**
   * @param \Drupal\Core\Session\AccountInterface $current_user
   *   Current user.
   * 
   * @param Drupal\Core\State\State $state
   *   The object State.
   */
  public function __construct(MailerService $mailer, OtpGeneratorService $otpGenerator, AccountInterface $current_user, State $state) {
    $this->otpMailer = $mailer;
    $this->otpGenerator = $otpGenerator;
    $this->currentUser = $current_user;
    $this->state = $state;
  }

  /**
   *
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('email_otp_login.mailer'),
      $container->get('email_otp_login.generator'),
      $container->get('current_user'),
      $container->get('state')
    );
  }

  /**
   * Generate OTP and send to user's email.
   */
  public function generateOtp() {
    $user = $this->currentUser;
    $email = $user->getEmail();
    $otp = $this->otpGenerator->generateOtp();

    // Send OTP to user's email.
    $this->otpMailer->sendOtpEmail($email, $otp);

    // Store OTP temporarily.
    $this->state->set('otp_code_' . $email, $otp);

    // Redirect to login page.
    return $this->redirect('user.login');
  }

}
