/**
 * Init: enterMediaDb brickvertical (jquery-brickvertical,js)
 * Init: enterMediaDb simpleLightbox (jquery-simpleLightbox.js)
 * 
 * oEmbed plugin only
 */
(function ($) {
	jQuery(document).ready(function () {
	    var grid = $(".masonry-grid2");
		grid.brickvertical();
		var slb = $('a.lightbox').simpleLightbox({
			captionSelector: 'self',
			captionType: 'data',
			captionsData: 'caption',
			captionDelay: 250,
			widthRatio:0.98,
			heightRatio:0.98,
			overlayOpacity: 1
		});
		slb.on("shown.simplelightbox", function () {
			var lang = document.documentElement.lang;
			if(!lang) {
				var drupalSelector = $("script[data-drupal-selector='drupal-settings-json']").text();
				if(drupalSelector) {
					var drupalSettings = JSON.parse(drupalSelector);
					lang = drupalSettings.dataLayer.defaultLang;
				}
			}
			if(lang) {
				var locales = $(this).data("locales");
				if(locales) {
					if (typeof locales === "string") {
						var txt = document.createElement("textarea");
						txt.innerHTML = locales;
						locales = JSON.parse(txt.value);
					}
					var localeCaption = locales[lang];
					if(localeCaption) {
						$(".sl-caption").html(localeCaption);
					}
				}
			}
			
			var dl = $(this).data("downloadlink");
			if(dl) {
				$(".simple-lightbox").append("<a class='sl-dl' href='" + dl + "' target='_blank'></a>");
			}
		})
	});
}(jQuery));	
