# Empty Headings Filter

Provides a text filter that removes empty heading tags (h1–h6) and replaces
them with paragraph tags for accessibility compliance.

## Overview

Empty heading tags are problematic for accessibility as they create semantic
confusion for screen readers and assistive technologies. This commonly occurs
when content editors create a new line from the beginning of a heading to
create a new line above it.

This filter automatically detects and converts empty headings to paragraph
tags, maintaining visual spacing while fixing accessibility issues.

## Installation

1. Enable the module: `drush en empty_headings_filter`
2. Go to **Configuration > Content authoring > Text formats and editors**
3. Edit your desired text format (e.g., "Full HTML")
4. Enable the "Empty headings filter" checkbox
5. Configure the filter weight as needed (default: 10)
6. Save configuration

## Testing

This module includes full PHPUnit coverage:

- **Unit tests** for the filter logic (covering whitespace, `&nbsp;`, comments,
  empty inline wrappers, attributes, children, and `<br>`).
- **Kernel tests** to verify plugin discovery and annotation metadata
  (filter ID and type) against the README contract.

Run all tests for this module:

```bash
vendor/bin/phpunit -c core/phpunit.xml.dist \
  modules/custom/empty_headings_filter/tests
```

## License

GPL-2.0+
