<?php

declare(strict_types=1);

namespace Drupal\Tests\empty_headings_filter\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\filter\Plugin\FilterInterface;

/**
 * Minimal kernel test to ensure plugin discovery and README contract.
 *
 * @group empty_headings_filter
 */
final class EmptyHeadingsFilterKernelTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'filter',
    'empty_headings_filter',
  ];

  /**
   * Tests that the plugin definition matches the README contract.
   */
  public function testPluginDefinitionMatchesReadme(): void {
    /** @var \Drupal\filter\FilterPluginManager $manager */
    $manager = $this->container->get('plugin.manager.filter');
    $plugin  = $manager->createInstance('empty_headings_filter');
    $def     = $plugin->getPluginDefinition();

    // Filter id must match README.
    $this->assertSame('empty_headings_filter', $def['id']);
    // README specifies a reversible transform.
    // "Filter Type: TYPE_TRANSFORM_REVERSIBLE" and "replaces empty headings
    // with <p>". (See README Technical Details and What it does.)
    $this->assertSame(FilterInterface::TYPE_TRANSFORM_REVERSIBLE, $def['type']);
  }

}
