![Emulsify Design System](https://github.com/emulsify-ds/.github/blob/6bd435be881bd820bddfa05d88905efe29176a0a/assets/images/header.png)

# Emulsify Drupal

## Emulsify is an open-source toolset for creating and implementing design systems on your website

### Storybook development, Webpack build, and Drupal 11 theme

**Emulsify Drupal** provides a [Storybook](https://storybook.js.org/) component library, a [Webpack](https://webpack.js.org/) development environment, and a Drupal 11 starter kit theme.

## Documentation

[docs.emulsify.info](https://emulsify.info/docs)

### Quick Links

1. [Installation](https://www.emulsify.info/docs/emulsify-drupal)
2. [Usage](https://www.emulsify.info/docs/emulsify-drupal/basic-usage/commands)

## Demo

1. [Storybook](http://storybook.emulsify.info/)

## Contributing

### [Code of Conduct](https://github.com/emulsify-ds/emulsify-drupal/blob/main/CODE_OF_CONDUCT.md)

The project maintainers have adopted a Code of Conduct that we expect project participants to adhere to. Please read the full text so that you can understand what actions will and will not be tolerated.

### Contribution Guide

Please also follow the issue template and pull request templates provided. See below for the correct places to post issues:

1. [Emulsify Drupal](https://www.drupal.org/project/issues/emulsify?categories=All)
2. [Emulsify Tools Drupal Module](https://www.drupal.org/project/issues/emulsify_tools?categories=All)
3. [Emulsify Twig Extensions](https://github.com/emulsify-ds/emulsify-twig-extensions/issues)

### Committing Changes

To facilitate automatic semantic release versioning, we utilize the [Conventional Changelog](https://github.com/conventional-changelog/conventional-changelog) standard through Commitizen. Follow these steps when commiting your work to ensure semantic release can version correctly.

1. Stage your changes, ensuring they encompass exactly what you wish to change, no more.
2. Run the `commit` script via `yarn commit` or `npm run commit` and follow the prompts to craft the perfect commit message.
3. Your commit message will be used to create the changelog for the next version that includes that commit.

## Author

Emulsify&reg; is a product of [Four Kitchens &mdash; We make BIG websites](https://fourkitchens.com).

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ModulesUnraveled"><img src="https://avatars.githubusercontent.com/u/1663810?v=4?s=100" width="100px;" alt="Brian Lewis"/><br /><sub><b>Brian Lewis</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=ModulesUnraveled" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=ModulesUnraveled" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/amazingrando"><img src="https://avatars.githubusercontent.com/u/409903?v=4?s=100" width="100px;" alt="Randy Oest"/><br /><sub><b>Randy Oest</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=amazingrando" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=amazingrando" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/callinmullaney"><img src="https://avatars.githubusercontent.com/u/369018?v=4?s=100" width="100px;" alt="Callin Mullaney"/><br /><sub><b>Callin Mullaney</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=callinmullaney" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=callinmullaney" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/patrickocoffeyo"><img src="https://avatars.githubusercontent.com/u/1107871?v=4?s=100" width="100px;" alt="Patrick Coffey"/><br /><sub><b>Patrick Coffey</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=patrickocoffeyo" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=patrickocoffeyo" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/infiniteluke"><img src="https://avatars.githubusercontent.com/u/1127238?v=4?s=100" width="100px;" alt="Luke Herrington"/><br /><sub><b>Luke Herrington</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=infiniteluke" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=infiniteluke" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/acouch"><img src="https://avatars.githubusercontent.com/u/512243?v=4?s=100" width="100px;" alt="Aaron Couch"/><br /><sub><b>Aaron Couch</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=acouch" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=acouch" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/codechefmarc"><img src="https://avatars.githubusercontent.com/u/107938318?v=4?s=100" width="100px;" alt="Marc Berger"/><br /><sub><b>Marc Berger</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=codechefmarc" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=codechefmarc" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/techninja"><img src="https://avatars.githubusercontent.com/u/320747?v=4?s=100" width="100px;" alt="James Todd"/><br /><sub><b>James Todd</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=techninja" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=techninja" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/KurtTrowbridge"><img src="https://avatars.githubusercontent.com/u/848721?v=4?s=100" width="100px;" alt="Kurt Trowbridge"/><br /><sub><b>Kurt Trowbridge</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=KurtTrowbridge" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=KurtTrowbridge" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/ccjjmartin"><img src="https://avatars.githubusercontent.com/u/12279982?v=4?s=100" width="100px;" alt="Chris Martin"/><br /><sub><b>Chris Martin</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=ccjjmartin" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=ccjjmartin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/americkson"><img src="https://avatars.githubusercontent.com/u/545638?v=4?s=100" width="100px;" alt="Adam Erickson"/><br /><sub><b>Adam Erickson</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=americkson" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=americkson" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/cruno91"><img src="https://avatars.githubusercontent.com/u/1760366?v=4?s=100" width="100px;" alt="Chris Runo"/><br /><sub><b>Chris Runo</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=cruno91" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=cruno91" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/andycarlberg"><img src="https://avatars.githubusercontent.com/u/7405933?v=4?s=100" width="100px;" alt="Andy Carlberg"/><br /><sub><b>Andy Carlberg</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=andycarlberg" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=andycarlberg" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/eatsmarter-benny"><img src="https://avatars.githubusercontent.com/u/78405000?v=4?s=100" width="100px;" alt="eatsmarter-benny"/><br /><sub><b>eatsmarter-benny</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=eatsmarter-benny" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=eatsmarter-benny" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/backlineint"><img src="https://avatars.githubusercontent.com/u/889478?v=4?s=100" width="100px;" alt="Brian Perry"/><br /><sub><b>Brian Perry</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=backlineint" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=backlineint" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/israelshmueli"><img src="https://avatars.githubusercontent.com/u/315597?v=4?s=100" width="100px;" alt="Israel Shmueli"/><br /><sub><b>Israel Shmueli</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=israelshmueli" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=israelshmueli" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/openjck"><img src="https://avatars.githubusercontent.com/u/933396?v=4?s=100" width="100px;" alt="John Karahalis"/><br /><sub><b>John Karahalis</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=openjck" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=openjck" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/Mihaic100"><img src="https://avatars.githubusercontent.com/u/14100169?v=4?s=100" width="100px;" alt="Mihaic100"/><br /><sub><b>Mihaic100</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=Mihaic100" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=Mihaic100" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="16.66%"><a href="https://github.com/psebborn"><img src="https://avatars.githubusercontent.com/u/147779?v=4?s=100" width="100px;" alt="Paul Sebborn"/><br /><sub><b>Paul Sebborn</b></sub></a><br /><a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=psebborn" title="Code">💻</a> <a href="https://github.com/fourkitchens/emulsify-drupal/commits?author=psebborn" title="Documentation">📖</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
