(function ($, Drupal) {
  Drupal.behaviors.encryptedLogin = {
    attach: function (context, settings) {
      // Fetch the AES key from the server.
      $.get('/encrypted_login/get_aes_key', function (response) {
        const aesKeyBase64 = response.key;
        const aesKey = CryptoJS.enc.Base64.parse(aesKeyBase64);

        $('.user-login-form').on('submit', function (event) {
          event.preventDefault();

          const password = $(this).find('#edit-pass').val();

          // Generate a 16-byte IV for password encryption.
          const ivPassword = CryptoJS.lib.WordArray.random(16);
          const encryptedPassword = CryptoJS.AES.encrypt(
            CryptoJS.enc.Utf8.parse(password),
            aesKey,
            { iv: ivPassword }
          );
          const encryptedPasswordCombined = CryptoJS.enc.Base64.stringify(ivPassword) + '::' + encryptedPassword.toString();

          // Set encrypted values in hidden fields.
          $('#edit-encrypted-password').val(btoa(encryptedPasswordCombined));

          // Clear plaintext fields.
          $('#edit-pass').val('');

          // Submit the form.
          this.submit();
        });
      });
    }
  };
})(jQuery, Drupal);
