<?php

namespace Drupal\encrypted_login\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Provides a controller for handling AES key retrieval.
 */
class EncryptedLoginController extends ControllerBase {

  /**
   * Retrieves the latest AES key for client-side encryption.
   *
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   *   A JSON response containing the AES key or an error message.
   */
  public function getAesKey() {
    // Fetch the latest AES key from the 'encrypted_login_keys' table.
    $key = \Drupal::database()->select('encrypted_login_keys', 'k')
      ->fields('k', ['aes_key'])
      ->orderBy('created', 'DESC')
      ->range(0, 1)
      ->execute()
      ->fetchField();

    // Return the AES key if found, otherwise return an error response.
    if ($key) {
      return new JsonResponse(['key' => $key]);
    }

    return new JsonResponse(['error' => 'AES key not found.'], 500);
  }

}
