(function ($, Drupal, once) {
  Drupal.behaviors.encryptedLogin = {
    attach: function (context, settings) {
      async function initEncryption() {
        try {
          const response = await $.get('/encrypted_login/getPublicKey');
          const publicKey = response.public_key || response.key;
          if (!publicKey) {
            console.error("Failed to retrieve RSA public key.");
            return;
          }

          const cryptoKey = await window.crypto.subtle.generateKey(
            { name: "AES-GCM", length: 256 },
            true,
            ["encrypt", "decrypt"]
          );
          const exportedKey = await window.crypto.subtle.exportKey("raw", cryptoKey);
          const aesKeyBase64 = btoa(String.fromCharCode(...new Uint8Array(exportedKey)));

          const aesKeyWordArray = CryptoJS.enc.Base64.parse(aesKeyBase64);

          once('encrypted-login', '.user-login-form', context).forEach(function (element) {
            $(element).on('submit', async function (event) {
              event.preventDefault();
              const $form = $(element);
              const password = $form.find('#edit-pass').val();
              if (!password) {
                console.error("No password entered.");
                return;
              }
              try {
                const iv = CryptoJS.lib.WordArray.random(16);

                const encrypted = CryptoJS.AES.encrypt(
                  CryptoJS.enc.Utf8.parse(password),
                  aesKeyWordArray,
                  { iv: iv }
                );

                const ivBase64 = CryptoJS.enc.Base64.stringify(iv);
                const encryptedPasswordCombined = ivBase64 + "::" + encrypted.toString();
                const encryptedPasswordFinal = btoa(encryptedPasswordCombined);

                const jsEncrypt = new JSEncrypt();
                jsEncrypt.setPublicKey(publicKey);
                const encryptedAesKey = jsEncrypt.encrypt(aesKeyBase64);
                if (!encryptedAesKey) {
                  console.error("RSA encryption of AES key failed.");
                  return;
                }

                $form.find('#edit-encrypted-password').val(encryptedPasswordFinal);
                $form.find('#edit-encrypted-aes-key').val(encryptedAesKey);

                $form.find('#edit-pass').val('');
                $form.off('submit');
                $form.submit();
              } catch (error) {
                console.error("Encryption process failed:", error);
              }
            });
          });
        } catch (error) {
          console.error("Failed to initialize encryption:", error);
        }
      }

      initEncryption();
    }
  };
})(jQuery, Drupal, once);
