# Enforce Revision

A Drupal 10/11+ module that enforces revision creation for content types based on user roles and bundles.

## Features

- **Role-based enforcement**: Configure which user roles must create revisions for specific content types
- **Bundle-specific settings**: Different enforcement rules for different content types
- **Flexible UI options**: Choose to disable the checkbox or hide it completely
- **Form integration**: Automatically modifies the "Create new revision" toggle for restricted users
- **Entity-level enforcement**: Ensures revisions are created even if form manipulation is attempted

## Configuration

### Basic Setup

1. Navigate to **Configuration > Content authoring > Enforce Revision Settings**
2. For each content type you want to configure:
   - Check "Enable revision enforcement"
   - Select the user roles that should be restricted
   - Optionally check "Hide revision checkbox entirely" to completely remove the UI element
3. Save the configuration

## How It Works

### Form Alteration
- Hooks into `hook_form_node_form_alter()`
- Two enforcement modes:
  - **Disable mode**: Checkbox is checked and disabled with explanatory text
  - **Hide mode**: Checkbox is completely hidden with informational message
- UID 1 (super admin) always exempt from all enforcement

### Entity-Level Protection
- Uses `hook_entity_presave()` to enforce revision creation
- Provides fallback protection against form manipulation
- Automatically sets revision log messages

### Service Architecture
- `RevisionEnforcer` service handles all enforcement logic
- Dependency injection for testability and maintainability
- Clean separation of concerns

## Permissions

- **administer enforce revision settings**: Access to configuration form
  - Restricted access by default
  - Required to modify enforcement settings

## Technical Details

### Requirements
- Drupal 10.0+ or Drupal 11.0+
- Node module (core dependency)
- User module (core dependency)
- PHP 8.1+

### Services
- `enforce_revision.revision_enforcer`: Main service for enforcement logic

### Configuration
- Settings stored in `enforce_revision.settings` config object
- Schema defined for validation and structure

### Hooks Implemented
- `hook_help()`: Module documentation
- `hook_form_node_form_alter()`: Form modification
- `hook_form_alter()`: Additional form patterns
- `hook_entity_presave()`: Entity-level enforcement
- `hook_install()`: Setup and welcome message
- `hook_uninstall()`: Cleanup
- `hook_requirements()`: Status reporting


## License

This module follows the same license as Drupal core (GPL-2.0+).
