# Menu Revisions Module

This module provides functionality for managing menu revisions in your Drupal site. It allows you to track, revert, and manage changes made to menus over time.

## Features

- Tracks revisions of menus.
- Allows reverting to previous menu states.
- Integrates with Drupal's entity and menu systems.

## Installation

1. Place the module in your `modules` directory.
2. Enable the module using Drush:
   ```
    drush en menu_revisions
   ```
   Or via the Drupal admin interface.

## Uninstallation

To completely uninstall the module and remove all related data:

1. Delete all menu revision entities:
   ```
    drush entity:delete menu_revision
   ```
2. Uninstall the module:
   ```
    drush pm:uninstall menu_revisions
   ```

## Requirements

- Drupal 9 or higher
- Drush command-line tool

## Support

For issues or feature requests, please open an issue in the project repository.

## Intended Behavior of the Menu Revision

* Save Draft
   * User should see a new revision in the revision list link with current revision indicator next to ID
   * Revision ID should not be increments of 1
* Save Draft and publish
   * User should see a new revision in the revision list link with active revision indicator next to ID
   * Revision ID should not be increments of 1
* Edit Draft
   * User should be able edit Draft by click on the draft link
   * The Draft link should display the menu items in the correct order and with the correct title
* Create new menu Item using the top right button
   * Should see old revision does not have the menu item, should see that PUBLISHED theme (anonymous user) does not see the item
   * Preview from Draft should see the new menu item
   * Enabled checkbox should be disabled in the add menu item window.
   * The older revisions should not have the menu item when review
   * After reverted older revisions back to draft, the menu item should NOT be in the menu edit
   * After reverted older revisions back to draft, the menu item should NOT be in the draft preview
* Create new menu item using add child link from another menu item
   * Item should be created under the parent item in menu edit screen
   * Should see old revision does not have the menu item, should see that PUBLISHED theme (anonymous user) does not see the item
   * Preview from Draft should see the new menu item
   * If menu item is created with enabled = FALSE, menu item will NOT be shown.
   * The older revisions should not have the menu item when review
   * After reverted older revisions back to draft, the menu item should NOT be in the menu edit
   * After reverted older revisions back to draft, the menu item should NOT be in the draft preview
* Disable existing menu item and save draft
   * Should see the the item no longer available in new revision
   * The menu item should still be available in older revisions that had the menu item previously
   * The live menu should not have the item disabled
* Disable existing menu item and save and publish
   * Should see the the item no longer available in new revision
   * The menu item should still be available in older revisions that had the menu item previously
   * The live menu should have the item disabled
* Delete Menu Item from Menu Item Edit screen
   * Should no longer see the menu item in draft
   * Should still see the menu item in previous revisions that already had it
* Updating Menu Item Detail in Menu Item Edit screen
   * The updates should reflect when edit the item again
   * The update should NOT reflect when edit the item again AFTER revert from a revision that does not have these updates
   * Updating the parent of the item should reflect on the menu draft edit screen
* Reordering the menu items and Save
   * The order of the items should be reflected in draft after save
   * The order of the items should NOT change the order of menu items in current active menu
   * The order or the items should not change the order of menu items in the previous revisions
* Deleting Menu Item that has children
   * The Menu item will be removed however, the children will move up one level.
