<?php

namespace Drupal\menu_revisions\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityPublishedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a menu revision entity.
 */
interface MenuRevisionInterface extends ContentEntityInterface, EntityOwnerInterface, EntityPublishedInterface {

  /**
   * Gets the menu revision creation timestamp.
   *
   * @return int
   *   Creation timestamp.
   */
  public function getCreatedTime();

  /**
   * Sets the menu revision creation timestamp.
   *
   * @param int $timestamp
   *   The creation timestamp.
   *
   * @return \Drupal\menu_revisions\Entity\MenuRevisionInterface
   *   The menu revision entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Gets the menu name.
   *
   * @return string
   *   The menu machine name.
   */
  public function getMenuName();

  /**
   * Sets the menu name.
   *
   * @param string $menu_name
   *   The menu machine name.
   *
   * @return \Drupal\menu_revisions\Entity\MenuRevisionInterface
   *   The menu revision entity.
   */
  public function setMenuName($menu_name);

  /**
   * Returns whether this is the default revision.
   *
   * @return bool
   *   TRUE if this is the default revision, FALSE otherwise.
   */
  public function isDefault();

  /**
   * Sets the default status of the revision.
   *
   * @param bool $is_default
   *   TRUE to set as default revision, FALSE otherwise.
   *
   * @return \Drupal\menu_revisions\Entity\MenuRevisionInterface
   *   The menu revision entity.
   */
  public function setDefault($is_default);

  /**
   * Gets the menu revision status.
   *
   * @return bool
   *   The menu revision status.
   */
  public function getStatus();

  /**
   * Sets the menu revision status.
   *
   * @param bool $status
   *   The menu revision status.
   *
   * @return \Drupal\menu_revisions\Entity\MenuRevisionInterface
   *   The menu revision entity.
   */
  public function setStatus($status);

}
