<?php

/**
 * This class overrides the default menu edit form route so we can use Edit Active Menu instead, this will leverage the menu revision system instead of the default menu system.
 */
namespace Drupal\menu_revisions\EventSubscriber;

use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;

class MenuEditRedirectSubscriber implements EventSubscriberInterface {
  public static function getSubscribedEvents() {
    return [
      KernelEvents::REQUEST => 'onKernelRequest',
    ];
  }

  public function onKernelRequest(RequestEvent $event) {
    $request = $event->getRequest();

    if ($request->attributes->get('_route') === 'entity.menu.edit_form') {
      $menu_revision_service = \Drupal::service('menu_revisions.manager');
      $menu_id = $request->attributes->get('menu')->id();
      $config = \Drupal::config('menu_revisions.settings');
      $menuID = $menu_id;

      if (!in_array($menuID,$config->get('selected_menu'))) {
        return;
      }

      if (empty($menu_id)) {
        return;
      }

      if ($menu_revision_service->isMenuRevisionable($menu_id))
      {
        $url = Url::fromRoute('entity.menu.draft', ['menu' => $menu_id])->toString();
        $event->setResponse(new RedirectResponse($url));
      }
      else
      {
        \Drupal::messenger()->addWarning(t('Menu Revision Not Enabled due to menu content (not menu link content) is not compatible with Menu Revisions'));
        return;
      }



    }
  }
}
