<?php
namespace Drupal\menu_revisions\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Menu\MenuTreeParameters;
use Drupal\Core\Menu\MenuTree;
use Drupal\Core\Menu\MenuTreeStorageInterface;

class MenuRevisionAdminForm extends ConfigFormBase
{
  /**
   * {@inheritdoc}
   */
  public function getFormId()
  {
    return 'menu_revisions_admin_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames()
  {
    return ['menu_revisions.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $menu_storage = \Drupal::entityTypeManager()->getStorage('menu');
    $menus = $menu_storage->loadMultiple();

    $options = [];
    foreach ($menus as $menu) {
      $options[$menu->id()] = $menu->label();
    }

    $config = $this->config('menu_revisions.settings');

    $form['selected_menu'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Select one or more menus to enable revisions for'),
      '#options' => $options,
      '#default_value' => (array) $config->get('selected_menu')
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state)
  {

    $selected_menus = array_filter($form_state->getValue('selected_menu'));
    $menu_revision_service = \Drupal::service('menu_revisions.manager');

    foreach ($selected_menus as $menu_id) {
      //create a default revision for the item if it doesn't exist
      //automatically create a new revision if the menu is revisionable and selected and does not have any revisions
      if ($menu_revision_service->getLatestRevision($menu_id) == NULL)
      {
        $menu_revision_service->createRevisionFromMenu($menu_id);
        $menu_revision_service->publishDraftMenu($menu_id);
      }

      if (!$menu_revision_service->isMenuRevisionable($menu_id)) {
        $this->messenger()->addError($this->t('Unable to save the items due to incompatible menu.'));
        return;
      }
    }
    $this->config('menu_revisions.settings')
      ->set('selected_menu', $form_state->getValue('selected_menu'))
      ->save();
    \Drupal::service('config.factory')->reset('menu_revisions.settings');
    parent::submitForm($form, $form_state);
  }
}
