<?php

namespace Drupal\menu_revisions\Services;

/**
 * Defines an interface for the Menu Hierarchy Manager service.
 */
interface MenuHierarchyInterface {

  /**
   * Captures the current hierarchy of a menu for a given revision.
   *
   * @param string $menu_name
   *   The machine name of the menu.
   * @param int $menu_revision_id
   *   The ID of the menu revision entity.
   *
   * @return void
   */
  public function captureMenuHierarchy(string $menu_name, int $menu_revision_id): void;

  /**
   * Retrieves hierarchy information for a specific menu revision.
   *
   * @param int $menu_revision_id
   *   The menu revision ID.
   *
   * @return array
   *   An associative array of menu item hierarchy data, keyed by UUID.
   *   Each item contains:
   *   - id: The menu link content entity ID.
   *   - parent: The parent plugin ID.
   *   - weight: The weight of the menu link.
   *   - plugin_id: The plugin ID of the link.
   */
  public function getMenuHierarchy(int $menu_revision_id): array;

}
