<?php

namespace Drupal\menu_revisions\Services;

/**
 * Interface for menu revision manager.
 */
interface MenuRevisionManagerInterface {

  /**
   * Creates a new menu revision from an existing menu.
   *
   * @param string $menu_name
   *   The machine name of the menu.
   *
   * @return int
   *   The ID of the created menu revision.
   */
  public function createRevisionFromMenu($menu_name);

  /**
   * Captures the current revisions of all menu links in a menu.
   *
   * @param string $menu_name
   *   The machine name of the menu.
   * @param int $menu_revision_id
   *   The ID of the menu revision entity.
   */
  public function captureMenuLinkRevisions($menu_name, $menu_revision_id);

  /**
   * Gets the default revision for a menu.
   *
   * @param string $menu_name
   *   The machine name of the menu.
   *
   * @return \Drupal\menu_revisions\Services\MenuRevisionManagerInterface|null
   *   The default menu revision, or NULL if none exists.
   */
  public function getDefaultRevision($menu_name);

  /**
   * Reverts a menu to a specific revision.
   *
   * @param int $menu_revision_id
   *   The ID of the menu revision to revert to.
   *
   * @return int|false
   *   The ID of the new revision created after revert, or FALSE if failed.
   */
  public function revertMenuToRevision($menu_revision_id);

 /**
   * Publishes a draft menu.
   *
   * @param string $menu_name
   *   The menu machine name.
   *
   * @return bool
   *   TRUE if successful, FALSE otherwise.
   */
  public function publishDraftMenu($menu_name);

  /**
   * Gets the latest published revision for a menu.
   *
   * @param string $menu_name
   *   The menu machine name.
   *
   * @return \Drupal\menu_revisions\Entity\MenuRevision|null
   *   The published revision or NULL if none exists.
   */
  public function getLatestPublishedRevision($menu_name);
}
