<?php

namespace Drupal\menu_revisions\Utils;

/**
 * Class for helping with menu tree based operations
 */
class MenuTreeUtil
{

  /**
   *
   * This function will generate a drupal menu.link_tree object with menu tree elements
   *
   * parameter is an array contain arrays with following elements
   *
   * 'title' => $menu_item->getTitle(),
   * 'url' => $menu_item->getUrlObject(),
   * 'below' => [],
   * 'attributes' => [],
   * 'original_link' => $menu_item,
   * 'plugin_id' => $uuid,
   * 'parent' => $parent,
   * 'localized_options' => [],
   * 'in_active_trail' => FALSE,
   * 'is_expanded' => FALSE,
   * 'is_collapsed' => FALSE,
   * 'is_active' => FALSE,
   * 'access' => TRUE,
   * 'weight' => $menu_item->getWeight(),
   */
  public function generateMenuTree($menuID,$menurevisionid, $menu_items)
  {
    $tree = [];
    $menu_item_link_revisions = \Drupal::service('menu_revisions.manager')->getMenuTreeLinksFromMenuRevision($menuID, $menurevisionid);
    $hierachy = \Drupal::service('menu_revisions.hierarchy_manager')->getMenuHierarchy($menurevisionid);

    // the hierachy is an array of menu tree structures based on parent relationship, the array element contains parent's plugin id
    // and also contains the id of the menu link itself.

    // the menu item array is just an array of data contain a simple list of rendering array data
    // it contains the menu link content id, the plugin_id
    foreach ($menu_items as $uuid => $item) {
      $subtree = !empty($item['below']) ? $this->generateMenuTree($item['below']) : [];
      $tree[$uuid] = new \Drupal\Core\Menu\MenuLinkTreeElement(
        $menu_item_link_revisions[$uuid],
        false,
        $item['depth'] ?? 1,
        $item['in_active_trail'] ?? FALSE,
        !empty($item['below']) ? $this->generateMenuTree($item['below']) : [],
      );
    }
    $this->buildMenuTreeWithSubTree($tree, $hierachy);

    return $tree;

  }

  public function buildMenuTreeWithSubTree(&$menuTreeFlat, $hierarchy) {
    // Get the top level elements.
    foreach ($menuTreeFlat as $uuid => $menulinkElement) {
      // Search for its children in the hierarchy.
      $weight = NULL;
      foreach ($hierarchy as $plugin_uuid => $hierarchyItem) {
        // Since we are looping anyway, let's find the weight.
        if (!$weight && strpos($plugin_uuid, $uuid) !== FALSE) {
          $weight = $hierarchyItem['weight'];
          $updatedDefinitions = [
            'weight' => $weight,
          ];
          $menulinkElement->link->updateLink($updatedDefinitions, FALSE);
        }
        if (strpos($hierarchyItem['parent'], $uuid) !== FALSE) {
          // We found the direct child.
          // Now we need to get the child tree element.
          $childElementKey = explode(':', $hierarchyItem['plugin_id'])[1];
          $childElement = $menuTreeFlat[$childElementKey];
          $menulinkElement->subtree[] = $childElement;
          $childElement->depth = $menulinkElement->depth + 1;
          $menulinkElement->hasChildren = TRUE;
        }
      }
    }

    // After processing, remove all non top level elements.
    foreach ($menuTreeFlat as $uuid => $menulinkElement) {
      foreach ($hierarchy as $hierarchyItem) {
        if ($hierarchyItem['parent'] !== "") {
          $uuidNonTopLevel = explode(':', $hierarchyItem['plugin_id'])[1];
          // Remove the child from the flat list.
          unset($menuTreeFlat[$uuidNonTopLevel]);
        }
      }
    }
  }


}
