<?php

namespace Drupal\Tests\menu_revisions\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\menu_revisions\Entity\MenuRevision;

/**
 * Tests the MenuRevision entity field definitions.
 *
 * @group menu_revisions
 */
class MenuRevisionKernelTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'menu_revisions',
  ];

  /**
   * Test base field definitions.
   */
  public function testBaseFieldDefinitions() {
    $fields = MenuRevision::baseFieldDefinitions(
      $this->container->get('entity_type.manager')->getDefinition('menu_revision')
    );

    $this->assertArrayHasKey('uid', $fields);
    $this->assertArrayHasKey('menu_name', $fields);
    $this->assertArrayHasKey('label', $fields);
    $this->assertArrayHasKey('is_default', $fields);
    $this->assertArrayHasKey('status', $fields);
    $this->assertArrayHasKey('description', $fields);
    $this->assertArrayHasKey('created', $fields);
    $this->assertArrayHasKey('changed', $fields);
  }

}
