<?php

namespace Drupal\Tests\menu_revisions\Unit;

use Drupal\Core\Database\Connection;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\menu_revisions\Services\MenuHierarchyManager;
use Drupal\menu_revisions\Services\MenuRevisionManager;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\menu_revisions\Services\MenuRevisionManager
 * @group menu_revisions
 */
class MenuRevisionManagerGetLatestActiveMenuRevisionTest extends UnitTestCase {

  /**
   * The menu revision manager under test.
   *
   * @var \Drupal\menu_revisions\Services\MenuRevisionManager
   */
  protected $menuRevisionManager;

  /**
   * The mocked entity type manager.
   *
   * @var \Prophecy\Prophecy\ObjectProphecy
   */
  protected $entityTypeManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->entityTypeManager = $this->prophesize(EntityTypeManagerInterface::class);
    
    // Set up other dependencies that aren't directly used in the test method
    $currentUser = $this->prophesize(AccountProxyInterface::class);
    $database = $this->prophesize(Connection::class);
    $loggerFactory = $this->prophesize(LoggerChannelFactoryInterface::class);
    $logger = $this->prophesize(LoggerChannelInterface::class);
    $loggerFactory->get('menu_revision')->willReturn($logger->reveal());
    $hierarchyManager = $this->prophesize(MenuHierarchyManager::class);

    $this->menuRevisionManager = new MenuRevisionManager(
      $this->entityTypeManager->reveal(),
      $currentUser->reveal(),
      $database->reveal(),
      $loggerFactory->reveal(),
      $hierarchyManager->reveal()
    );
  }

  /**
   * @covers ::getLatestActiveMenuRevision
   */
  public function testGetLatestActiveMenuRevision() {
    $menu_id = 'main';
    
    // Mock the menu revision query
    $menuRevisionQuery = $this->getMockBuilder(\stdClass::class)
      ->setMethods(['accessCheck', 'condition', 'sort', 'range', 'execute'])
      ->getMock();
    $menuRevisionQuery->expects($this->any())->method('accessCheck')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('condition')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('sort')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('range')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('execute')->willReturn([5 => 5]);
    
    $menuRevisionStorage = $this->prophesize(EntityStorageInterface::class);
    $menuRevisionStorage->getQuery()->willReturn($menuRevisionQuery);
    $this->entityTypeManager->getStorage('menu_revision')->willReturn($menuRevisionStorage->reveal());
    
    // Call the method under test
    $result = $this->menuRevisionManager->getLatestActiveMenuRevision($menu_id);
    
    // Assert
    $this->assertEquals(5, $result);
  }
  
  /**
   * @covers ::getLatestActiveMenuRevision
   */
  public function testGetLatestActiveMenuRevisionNoResults() {
    $menu_id = 'main';
    
    // Mock the menu revision query with no results
    $menuRevisionQuery = $this->getMockBuilder(\stdClass::class)
      ->setMethods(['accessCheck', 'condition', 'sort', 'range', 'execute'])
      ->getMock();
    $menuRevisionQuery->expects($this->any())->method('accessCheck')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('condition')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('sort')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('range')->willReturnSelf();
    $menuRevisionQuery->expects($this->any())->method('execute')->willReturn([]);
    
    $menuRevisionStorage = $this->prophesize(EntityStorageInterface::class);
    $menuRevisionStorage->getQuery()->willReturn($menuRevisionQuery);
    $this->entityTypeManager->getStorage('menu_revision')->willReturn($menuRevisionStorage->reveal());
    
    // Call the method under test
    $result = $this->menuRevisionManager->getLatestActiveMenuRevision($menu_id);
    
    // Assert
    $this->assertFalse($result);
  }
}